package cn.com.duiba.anticheat.center.api.domain.activity;

import java.io.Serializable;
import java.util.Date;

public class LotteryOrderParams implements Serializable {

    private static final long serialVersionUID = -1885066134678779637L;

    public static enum LotteryOrderTypeEnum {
        DUIBA_SINGLELOTTERY(1, "duiba-单品抽奖"),
        DUIBA_HDTOOL(2, "duiba-活动工具"),
        DUIBA_ROB(3, "duiba-今日必抢"),
        DUIBA_NGAME(4, "duiba-新游戏"),
        DUIBA_OGAME(5, "duiba-老游戏"),
        DUIBA_QUESTIONANSWER(6, "duiba-答题活动"),
        DUIBA_QUIZZ(7, "duiba-测试题"),
        DUIBA_GUESS(8, "duiba-竞猜"),
        DUIBA_FLOP(10, "duiba-趣味翻牌"),
        APP_SINGLELOTTERY(51, "app-单品抽奖"),
        APP_TURNTABLE(52, "app-幸运转盘"),
        APP_SHAKE(53, "app-摇一摇"),
        APP_SCRATCH(54, "app-刮刮乐"),
        APP_TIGER(55, "app-摇奖机");

        private int value;
        private String desc;

        LotteryOrderTypeEnum(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public int value() {
            return this.value;
        }

        public String desc() {
            return this.desc;
        }

        public static LotteryOrderTypeEnum fromValue(int value) {
            for (LotteryOrderTypeEnum it : LotteryOrderTypeEnum.values()) {
                if (value == it.value()) {
                    return it;
                }
            }
            return null;
        }
    }

    private Long lotteryOrderId; // 抽奖订单ID single_lottery_order hdtool_order
    private Long duibaActivityId; // 兑吧的活动ID 可以为null
    private LotteryOrderTypeEnum type;
    private Long operatingActivityId;
    private Date orderGmtCreate;
    private Long appId;
    private Long developerId;
    private String developerBizId; // 开发者的业务id
    private Long credits;

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Long getLotteryOrderId() {
        return lotteryOrderId;
    }

    public void setLotteryOrderId(Long lotteryOrderId) {
        this.lotteryOrderId = lotteryOrderId;
    }

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    public LotteryOrderTypeEnum getType() {
        return type;
    }

    public void setType(LotteryOrderTypeEnum type) {
        this.type = type;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Date getOrderGmtCreate() {
        return orderGmtCreate;
    }

    public void setOrderGmtCreate(Date orderGmtCreate) {
        this.orderGmtCreate = orderGmtCreate;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }
}
