/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Dates {
    public static DateHelper from(Date date) {
        return new DateHelper(date);
    }

    public static DateHelper from(long millis) {
        return new DateHelper(millis);
    }

    public static DateHelper from(String date, String format) {
        try {
            return new DateHelper(new SimpleDateFormat(format).parse(date));
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) with format(%s)!", date, format));
        }
    }

    public static DateHelper now() {
        return new DateHelper(System.currentTimeMillis());
    }

    public static class DateHelper {
        private Calendar m_cal = Calendar.getInstance();

        public DateHelper(Date date) {
            this.m_cal.setTime(date);
        }

        public DateHelper(long millis) {
            this.m_cal.setTimeInMillis(millis);
        }

        public Date asDate() {
            return this.m_cal.getTime();
        }

        public long asLong() {
            return this.m_cal.getTimeInMillis();
        }

        public String asString(String format) {
            return new SimpleDateFormat(format).format(this.m_cal.getTime());
        }

        public DateHelper beginOf(char field) {
            switch (field) {
                case 'Y': {
                    this.m_cal.set(2, 0);
                }
                case 'M': {
                    this.m_cal.set(5, 1);
                }
                case 'd': {
                    this.m_cal.set(11, 0);
                }
                case 'H': 
                case 'h': {
                    this.m_cal.set(12, 0);
                }
                case 'm': {
                    this.m_cal.set(13, 0);
                }
                case 's': {
                    this.m_cal.set(14, 0);
                    break;
                }
                case 'w': {
                    int firstDayOfWeek = this.m_cal.getFirstDayOfWeek();
                    int day = this.m_cal.get(7);
                    if (firstDayOfWeek <= day) {
                        this.m_cal.add(5, firstDayOfWeek - day);
                    } else {
                        this.m_cal.add(5, firstDayOfWeek - day - 7);
                    }
                    this.m_cal.set(11, 0);
                    this.m_cal.set(12, 0);
                    this.m_cal.set(13, 0);
                    this.m_cal.set(14, 0);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Unknown field(%s)!", Character.valueOf(field)));
                }
            }
            return this;
        }

        public DateHelper day(int delta) {
            this.m_cal.add(5, delta);
            return this;
        }

        public DateHelper endOf(char field) {
            switch (field) {
                case 'Y': {
                    this.m_cal.set(2, 11);
                }
                case 'M': {
                    this.m_cal.set(5, this.m_cal.getActualMaximum(5));
                }
                case 'd': {
                    this.m_cal.set(11, 23);
                }
                case 'H': 
                case 'h': {
                    this.m_cal.set(12, 59);
                }
                case 'm': {
                    this.m_cal.set(13, 59);
                }
                case 's': {
                    this.m_cal.set(14, 999);
                    break;
                }
                case 'w': {
                    int firstDayOfWeek = this.m_cal.getFirstDayOfWeek();
                    int day = this.m_cal.get(7);
                    if (firstDayOfWeek <= day) {
                        this.m_cal.add(5, 6 + firstDayOfWeek - day);
                    } else {
                        this.m_cal.add(5, firstDayOfWeek - day - 1);
                    }
                    this.m_cal.set(11, 23);
                    this.m_cal.set(12, 59);
                    this.m_cal.set(13, 59);
                    this.m_cal.set(14, 999);
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Unknown field(%s)!", Character.valueOf(field)));
                }
            }
            return this;
        }

        public DateHelper firstDayOfWeek(int value) {
            this.m_cal.setFirstDayOfWeek(value);
            return this;
        }

        public DateHelper hour(int delta) {
            this.m_cal.add(10, delta);
            return this;
        }

        public DateHelper minute(int delta) {
            this.m_cal.add(12, delta);
            return this;
        }
    }
}

