/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Reflects {
    private Reflects() {
    }

    public static ClassReflector forClass() {
        return ClassReflector.INSTANCE;
    }

    public static ConstructorReflector forConstructor() {
        return ConstructorReflector.INSTANCE;
    }

    public static FieldReflector forField() {
        return FieldReflector.INSTANCE;
    }

    public static MethodReflector forMethod() {
        return MethodReflector.INSTANCE;
    }

    public static ModifierReflector forModifier() {
        return ModifierReflector.INSTANCE;
    }

    public static ResourceReflector forResource() {
        return ResourceReflector.INSTANCE;
    }

    static class TypeArguments {
        private Class<?>[] m_types;
        private Object[] m_arguments;

        public TypeArguments(Object ... typesAndParameters) {
            int length = typesAndParameters.length;
            if (length % 2 != 0) {
                throw new IllegalArgumentException(String.format("Constrcutor argument types and data should be even, but was odd: %s.", length));
            }
            int half = length / 2;
            Class[] types = new Class[half];
            Object[] arguments = new Object[half];
            for (int i = 0; i < half; ++i) {
                types[i] = (Class)typesAndParameters[2 * i];
                arguments[i] = typesAndParameters[2 * i + 1];
            }
            this.m_types = types;
            this.m_arguments = arguments;
        }

        public Object[] getArguments() {
            return this.m_arguments;
        }

        public Class<?>[] getTypes() {
            return this.m_types;
        }
    }

    public static enum ResourceReflector {
        INSTANCE;


        public Properties getResource(Class<?> anchorClass, String resName) {
            Properties prop = this.getResource(((Object)((Object)this)).getClass().getClassLoader(), anchorClass, resName);
            if (prop == null) {
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                prop = this.getResource(classloader, anchorClass, resName);
            }
            return prop;
        }

        public Properties getResource(ClassLoader classloader, Class<?> anchorClass, String resName) {
            URL url = classloader.getResource(resName = this.getResourceName(anchorClass, resName));
            if (url != null) {
                try {
                    Properties prop = new Properties();
                    prop.load(url.openStream());
                    return prop;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Properties getResource(String resName) {
            return this.getResource(Reflects.class, resName);
        }

        private String getResourceName(Class<?> clazz, String resName) {
            if (resName.length() > 0 && resName.charAt(0) == '/') {
                return resName.substring(1);
            }
            String qualifiedClassName = clazz != null ? clazz.getName() : ((Object)((Object)this)).getClass().getName();
            int classIndex = qualifiedClassName.lastIndexOf(46);
            if (classIndex == -1) {
                return resName;
            }
            return qualifiedClassName.substring(0, classIndex + 1).replace('.', '/') + resName;
        }
    }

    public static enum ModifierReflector {
        INSTANCE;


        public boolean isAbstract(Class<?> clazz) {
            return Modifier.isAbstract(clazz.getModifiers());
        }

        public boolean isAbstract(Member member) {
            return Modifier.isAbstract(member.getModifiers());
        }

        public boolean isPublic(Class<?> clazz) {
            return Modifier.isPublic(clazz.getModifiers());
        }

        public boolean isPublic(Member member) {
            return Modifier.isPublic(member.getModifiers());
        }

        public boolean isStatic(Class<?> clazz) {
            return Modifier.isStatic(clazz.getModifiers());
        }

        public boolean isStatic(Member member) {
            return Modifier.isStatic(member.getModifiers());
        }
    }

    public static enum MethodReflector {
        INSTANCE;


        public Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
            try {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public List<Method> getDeclaredMethods(Class<?> clazz, IMemberFilter<Method> filter) {
            ArrayList<Method> list = new ArrayList<Method>();
            try {
                Method[] methods;
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    if (filter != null && !filter.filter(method)) continue;
                    list.add(method);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return list;
        }

        public String getGetMethodName(String propertyName) {
            int len;
            int n = len = propertyName == null ? 0 : propertyName.length();
            if (len == 0) {
                throw new IllegalArgumentException(String.format("Invalid property name: %s!", propertyName));
            }
            StringBuilder sb = new StringBuilder(len + 3);
            sb.append("get");
            sb.append(Character.toUpperCase(propertyName.charAt(0)));
            sb.append(propertyName.substring(1));
            return sb.toString();
        }

        public String getGetterName(Method method) {
            String name = method.getName();
            int length = name.length();
            if (length > 3 && name.startsWith("get")) {
                return Character.toLowerCase(name.charAt(3)) + name.substring(4);
            }
            if (length > 2 && name.startsWith("is")) {
                return Character.toLowerCase(name.charAt(2)) + name.substring(3);
            }
            return name;
        }

        public Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
            try {
                return clazz.getMethod(methodName, parameterTypes);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public List<Method> getMethods(Class<?> clazz, IMemberFilter<Method> filter) {
            ArrayList<Method> list = new ArrayList<Method>();
            try {
                Method[] methods;
                for (Method method : methods = clazz.getMethods()) {
                    if (filter != null && !filter.filter(method)) continue;
                    list.add(method);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return list;
        }

        public <T> T getPropertyValue(Object instance, String propertyName) {
            String methodName = this.getGetMethodName(propertyName);
            T value = this.invokeMethod(instance, methodName, new Object[0]);
            return value;
        }

        public <T> T invokeDeclaredMethod(Object instance, String methodName, Object ... typesAndParameters) {
            if (instance == null) {
                return null;
            }
            TypeArguments typeArgs = new TypeArguments(typesAndParameters);
            Method method = this.getDeclaredMethod(instance.getClass(), methodName, typeArgs.getTypes());
            if (method != null) {
                try {
                    method.setAccessible(true);
                    return (T)method.invoke(instance, typeArgs.getArguments());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public <T> T invokeMethod(Object instance, String methodName, Object ... typesAndParameters) {
            if (instance == null) {
                return null;
            }
            TypeArguments typeArgs = new TypeArguments(typesAndParameters);
            Method method = this.getMethod(instance.getClass(), methodName, typeArgs.getTypes());
            if (method != null) {
                try {
                    return (T)method.invoke(instance, typeArgs.getArguments());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public <T> T invokeStaticMethod(Class<?> clazz, String methodName, Object ... typesAndParameters) {
            if (clazz == null) {
                return null;
            }
            TypeArguments typeArgs = new TypeArguments(typesAndParameters);
            Method method = this.getMethod(clazz, methodName, typeArgs.getTypes());
            if (method != null) {
                try {
                    return (T)method.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean isGetter(Method method) {
            if (method.getParameterTypes().length > 0) {
                return false;
            }
            int modifier = method.getModifiers();
            if (!Modifier.isPublic(modifier) || Modifier.isStatic(modifier)) {
                return false;
            }
            String name = method.getName();
            if (name.startsWith("get") && !name.equals("getClass")) {
                return true;
            }
            return name.startsWith("is") && method.getReturnType() == Boolean.TYPE;
        }
    }

    public static enum MethodFilter implements IMemberFilter<Method>
    {
        PUBLIC{

            @Override
            public boolean filter(Method method) {
                return ModifierReflector.INSTANCE.isPublic(method);
            }
        }
        ,
        STATIC{

            @Override
            public boolean filter(Method method) {
                return ModifierReflector.INSTANCE.isStatic(method);
            }
        }
        ,
        PUBLIC_STATIC{

            @Override
            public boolean filter(Method method) {
                return ModifierReflector.INSTANCE.isPublic(method) && ModifierReflector.INSTANCE.isStatic(method);
            }
        };

    }

    public static interface IMemberFilter<T extends Member> {
        public boolean filter(T var1);
    }

    public static enum FieldReflector {
        INSTANCE;


        public List<Field> getAllDeclaredFields(Class<?> clazz, IMemberFilter<Field> filter) {
            ArrayList<Field> list = new ArrayList<Field>();
            for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = current.getDeclaredFields()) {
                    if (filter != null && !filter.filter(field)) continue;
                    list.add(field);
                }
            }
            return list;
        }

        public Field getDeclaredField(Class<?> clazz, String fieldName) {
            if (clazz != null) {
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    return field;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public List<Field> getDeclaredFields(Class<?> clazz, IMemberFilter<Field> filter) {
            Field[] fields;
            ArrayList<Field> list = new ArrayList<Field>();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (filter != null && !filter.filter(field)) continue;
                list.add(field);
            }
            return list;
        }

        public <T> T getDeclaredFieldValue(Class<?> clazz, String fieldName, Object instance) {
            Field field = this.getDeclaredField(clazz, fieldName);
            if (field != null) {
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return (T)field.get(instance);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean setDeclaredFieldValue(Class<?> clazz, String fieldName, Object instance, Object value) {
            Field field = this.getDeclaredField(clazz, fieldName);
            if (field != null) {
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(instance, value);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        public List<Field> getFields(Class<?> clazz, IMemberFilter<Field> filter) {
            Field[] fields;
            ArrayList<Field> list = new ArrayList<Field>();
            for (Field field : fields = clazz.getFields()) {
                if (filter != null && !filter.filter(field)) continue;
                list.add(field);
            }
            return list;
        }

        public <T> T getFieldValue(Object instance, String fieldName) {
            if (instance != null) {
                try {
                    Field field = instance.getClass().getField(fieldName);
                    return (T)field.get(instance);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public <T> T getStaticFieldValue(Class<?> clazz, String fieldName) {
            if (clazz != null) {
                try {
                    Field field = clazz.getField(fieldName);
                    return (T)field.get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public <T> T getStaticFieldValue(String className, String fieldName) {
            try {
                Class<?> clazz = Reflects.forClass().getClass(className);
                if (clazz != null) {
                    return this.getStaticFieldValue(clazz, fieldName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public <T> T getDeclaredFieldValue(Object instance, String ... fields) {
            Object value = instance;
            for (String field : fields) {
                if ((value = this.getDeclaredFieldValue(value.getClass(), field, value)) == null) break;
            }
            return (T)value;
        }
    }

    public static enum FieldFilter implements IMemberFilter<Field>
    {
        PUBLIC{

            @Override
            public boolean filter(Field field) {
                return ModifierReflector.INSTANCE.isPublic(field);
            }
        }
        ,
        STATIC{

            @Override
            public boolean filter(Field field) {
                return ModifierReflector.INSTANCE.isStatic(field);
            }
        }
        ,
        PUBLIC_STATIC{

            @Override
            public boolean filter(Field field) {
                return ModifierReflector.INSTANCE.isPublic(field) && ModifierReflector.INSTANCE.isStatic(field);
            }
        };

    }

    public static enum ConstructorReflector {
        INSTANCE;


        public Object createInstance(Class<?> clazz, Object ... typesAndParameters) {
            try {
                TypeArguments typeArgs = new TypeArguments(typesAndParameters);
                Constructor<?> constructor = clazz.getConstructor(typeArgs.getTypes());
                return constructor.newInstance(typeArgs.getArguments());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static enum ClassReflector {
        INSTANCE;


        public Class<?> getClass(String className) {
            return this.getClass(className, null);
        }

        public Class<?> getClass(String className, ClassLoader classloader) {
            Class<?> clazz;
            block7: {
                clazz = null;
                if (classloader != null) {
                    try {
                        clazz = classloader.loadClass(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                } else {
                    try {
                        clazz = Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        if (clazz == null) {
                            clazz = this.getClass(className, Thread.currentThread().getContextClassLoader());
                        }
                        if (clazz != null) break block7;
                        clazz = this.getClass(className, Reflects.class.getClassLoader());
                    }
                }
            }
            return clazz;
        }

        public Class<?> getClass2(String className) {
            return this.getClass2(className, null);
        }

        public Class<?> getClass2(String className, ClassLoader classloader) {
            int pos;
            Class<?> clazz = null;
            String name = className;
            while ((clazz = this.getClass(name, classloader)) == null && (pos = name.lastIndexOf(46)) >= 0) {
                name = name.substring(0, pos) + '$' + name.substring(pos + 1);
            }
            return clazz;
        }

        public Class<?> getNestedClass(Class<?> clazz, String simpleName) {
            Class<?>[] subClasses;
            if (clazz != null && (subClasses = clazz.getDeclaredClasses()) != null) {
                for (Class<?> subClass : subClasses) {
                    if (!subClass.getSimpleName().equals(simpleName)) continue;
                    return subClass;
                }
            }
            return null;
        }

        public Class<?> getNestedClass(String className, String simpleName) {
            return this.getNestedClass(this.getClass(className), simpleName);
        }

        public Class<?> getNestedClass(String className, String simpleName, ClassLoader classloader) {
            return this.getNestedClass(this.getClass(className, classloader), simpleName);
        }
    }
}

