/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unidal.helper.Reflects;

public class Stringizers {
    public static JsonStringizer forJson() {
        return JsonStringizer.DEFAULT;
    }

    static class LengthLimiter {
        private int m_maxLength;
        private int m_maxItemLength;
        private int m_halfMaxItemLength;
        private StringBuilder m_sb;

        public LengthLimiter(StringBuilder sb, int maxLength, int maxItemLength) {
            this.m_sb = sb;
            this.m_maxLength = maxLength - 3;
            this.m_maxItemLength = maxItemLength;
            this.m_halfMaxItemLength = maxItemLength / 2 - 1;
        }

        public LengthLimiter append(char ch) {
            this.m_sb.append(ch);
            return this;
        }

        public LengthLimiter append(Object value) {
            this.append(value, false);
            return this;
        }

        public LengthLimiter append(Object value, boolean itemLimit) {
            int len = this.m_sb.length();
            String str = this.getString(value, itemLimit);
            if (this.m_maxLength > 0 && len + str.length() > this.m_maxLength) {
                throw new RuntimeException("Length limited.");
            }
            this.m_sb.append(str);
            return this;
        }

        private String getString(Object value, boolean itemLimit) {
            int len;
            String str = String.valueOf(value);
            if (itemLimit && this.m_maxItemLength > 0 && (len = str.length()) > this.m_maxItemLength) {
                return str.substring(0, this.m_halfMaxItemLength) + "..." + str.substring(len - this.m_halfMaxItemLength, len);
            }
            return str;
        }
    }

    public static enum JsonStringizer {
        DEFAULT(false),
        COMPACT(true);

        private boolean m_compact;

        private JsonStringizer(boolean compact) {
            this.m_compact = compact;
        }

        public JsonStringizer compact() {
            return COMPACT;
        }

        public String from(Object obj) {
            return this.from(obj, 0, 0);
        }

        public String from(Object obj, int maxLength, int maxItemLength) {
            StringBuilder sb = new StringBuilder(1024);
            LengthLimiter limiter = new LengthLimiter(sb, maxLength, maxItemLength);
            HashSet<Object> done = new HashSet<Object>();
            try {
                this.fromObject(done, limiter, obj);
            }
            catch (RuntimeException e) {
                sb.append("...");
            }
            return sb.toString();
        }

        private void fromArray(Set<Object> done, LengthLimiter sb, Object obj) {
            int len = Array.getLength(obj);
            sb.append('[');
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(',');
                    if (!this.m_compact) {
                        sb.append(' ');
                    }
                }
                Object element = Array.get(obj, i);
                this.fromObject(done, sb, element);
            }
            sb.append(']');
        }

        private void fromCollection(Set<Object> done, LengthLimiter sb, Object obj) {
            boolean first = true;
            sb.append('[');
            for (Object item : (Collection)obj) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                    if (!this.m_compact) {
                        sb.append(' ');
                    }
                }
                this.fromObject(done, sb, item);
            }
            sb.append(']');
        }

        private void fromMap(Set<Object> done, LengthLimiter sb, Object obj) {
            boolean first = true;
            sb.append('{');
            for (Map.Entry e : ((Map)obj).entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                    if (!this.m_compact) {
                        sb.append(' ');
                    }
                }
                sb.append('\"').append(key).append("\":");
                if (!this.m_compact) {
                    sb.append(' ');
                }
                this.fromObject(done, sb, value);
            }
            sb.append('}');
        }

        private void fromObject(Set<Object> done, LengthLimiter sb, Object obj) {
            if (obj == null) {
                return;
            }
            Class<?> type = obj.getClass();
            if (type == String.class) {
                sb.append('\"').append(obj.toString(), true).append('\"');
            } else if (type.isPrimitive() || Number.class.isAssignableFrom(type) || type.isEnum()) {
                sb.append(obj.toString(), true);
            } else if (type == Boolean.class) {
                sb.append(obj.toString(), true);
            } else if (type == Date.class) {
                sb.append('\"').append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(obj), true).append('\"');
            } else if (type == Class.class) {
                sb.append('\"').append(obj, true).append('\"');
            } else {
                if (done.contains(obj)) {
                    sb.append("{}");
                    return;
                }
                done.add(obj);
                if (type.isArray()) {
                    this.fromArray(done, sb, obj);
                } else if (Collection.class.isAssignableFrom(type)) {
                    this.fromCollection(done, sb, obj);
                } else if (Map.class.isAssignableFrom(type)) {
                    this.fromMap(done, sb, obj);
                } else {
                    this.fromPojo(done, sb, obj);
                }
            }
        }

        private void fromPojo(Set<Object> done, LengthLimiter sb, Object obj) {
            Class<?> type = obj.getClass();
            if (this.hasToString(type)) {
                this.fromObject(done, sb, obj.toString());
                return;
            }
            List<Method> getters = Reflects.forMethod().getMethods(type, new Reflects.IMemberFilter<Method>(){

                @Override
                public boolean filter(Method method) {
                    return Reflects.forMethod().isGetter(method);
                }
            });
            Collections.sort(getters, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    return m1.getName().compareTo(m2.getName());
                }
            });
            if (getters.isEmpty()) {
                sb.append(obj.toString());
            } else {
                boolean first = true;
                sb.append('{');
                for (Method getter : getters) {
                    Object value;
                    String key = Reflects.forMethod().getGetterName(getter);
                    try {
                        if (!getter.isAccessible()) {
                            getter.setAccessible(true);
                        }
                        value = getter.invoke(obj, new Object[0]);
                    }
                    catch (Exception e) {
                        value = null;
                    }
                    if (value == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                        if (!this.m_compact) {
                            sb.append(' ');
                        }
                    }
                    sb.append('\"').append(key).append("\":");
                    if (!this.m_compact) {
                        sb.append(' ');
                    }
                    this.fromObject(done, sb, value);
                }
                sb.append('}');
            }
        }

        public boolean hasToString(Class<?> type) {
            try {
                Method method = type.getMethod("toString", new Class[0]);
                if (method.getDeclaringClass() != Object.class) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

