/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.configuration;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.unidal.lookup.configuration.Configuration;

public class Component {
    private ComponentDescriptor<Object> m_descriptor = new ComponentDescriptor();
    private List<ComponentRequirement> m_requirements;
    private Configuration m_configuration;

    public <T> Component(Class<T> roleClass) {
        this(roleClass, null, roleClass);
    }

    public <T> Component(Class<T> roleClass, Class<? extends T> implementationClass) {
        this(roleClass, null, implementationClass);
    }

    public <T> Component(Class<T> roleClass, Object roleHint, Class<? extends T> implementationClass) {
        this.m_descriptor.setRole(roleClass.getName());
        this.m_descriptor.setRoleHint(roleHint == null ? null : roleHint.toString());
        this.m_descriptor.setImplementation(implementationClass.getName());
        this.m_requirements = new ArrayList<ComponentRequirement>();
    }

    public Component config(Configuration ... children) {
        if (this.m_configuration == null) {
            this.m_configuration = new Configuration();
        }
        for (Configuration child : children) {
            this.m_configuration.add(child);
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Component) {
            String role2;
            Component other = (Component)obj;
            String role1 = this.m_descriptor.getRole();
            if (!role1.equals(role2 = other.m_descriptor.getRole())) {
                return false;
            }
            String roleHint1 = this.m_descriptor.getRoleHint();
            String roleHint2 = other.m_descriptor.getRoleHint();
            if (roleHint1 == null && roleHint2 == null) {
                return true;
            }
            if (roleHint1 != null && roleHint2 != null) {
                return roleHint1.equals(roleHint2);
            }
        }
        return false;
    }

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public ComponentDescriptor<Object> getDescriptor() {
        return this.m_descriptor;
    }

    public List<ComponentRequirement> getRequirements() {
        return this.m_requirements;
    }

    public int hashCode() {
        String role = this.m_descriptor.getRole();
        String roleHint = this.m_descriptor.getRoleHint();
        return role.hashCode() * 31 + (roleHint == null ? 0 : roleHint.hashCode());
    }

    public Component is(String instantiationStrategy) {
        this.m_descriptor.setInstantiationStrategy(instantiationStrategy);
        return this;
    }

    public Component lifecycle(String lifecycleHandler) {
        this.m_descriptor.setLifecycleHandler(lifecycleHandler);
        return this;
    }

    public Component req(Class<?> ... roleClasses) {
        for (Class<?> roleClass : roleClasses) {
            this.req(roleClass, "default", null);
        }
        return this;
    }

    public Component req(Class<?> roleClass, String roleHint) {
        return this.req(roleClass, roleHint, null);
    }

    public Component req(Class<?> roleClass, String roleHint, String fieldName) {
        ComponentRequirement requirement = new ComponentRequirement();
        requirement.setRole(roleClass.getName());
        requirement.setRoleHint(roleHint);
        requirement.setFieldName(fieldName);
        this.m_requirements.add(requirement);
        return this;
    }

    public Component req(Class<?> roleClass, String[] roleHints, String fieldName) {
        ComponentRequirementList requirement = new ComponentRequirementList();
        ArrayList<String> hints = new ArrayList<String>();
        for (String hint : roleHints) {
            if (hint == null) continue;
            hints.add(hint);
        }
        requirement.setRole(roleClass.getName());
        requirement.setRoleHints(hints);
        requirement.setFieldName(fieldName);
        this.m_requirements.add((ComponentRequirement)requirement);
        return this;
    }
}

