/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.codehaus.plexus.logging.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.unidal.helper.Threads;
import org.unidal.lookup.logger.LoggerFactory;
import org.unidal.net.MessageDelegate;

@Deprecated
class MessageReceiver {
    private MessageDelegate m_delegate;
    private int m_port;
    private String m_host;
    private int m_maxThreads;
    private String m_threadNamePrefix;
    private ServerBootstrap m_bootstrap;
    private ChannelGroup m_channelGroup = new DefaultChannelGroup();
    private Logger m_logger = LoggerFactory.getLogger(MessageReceiver.class);

    public MessageReceiver(MessageDelegate delegate, int port, String host) {
        this.m_delegate = delegate;
        this.m_port = port;
        this.m_host = host;
        this.m_threadNamePrefix = delegate.getClass().getSimpleName();
    }

    public void setMaxThreads(int maxThreads) {
        this.m_maxThreads = maxThreads;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.m_threadNamePrefix = threadNamePrefix;
    }

    public void shutdown() {
        this.m_channelGroup.close().awaitUninterruptibly();
        this.m_bootstrap.getFactory().releaseExternalResources();
    }

    public void startServer() {
        NioServerSocketChannelFactory factory;
        ExecutorService bossExecutor;
        String name;
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)ThreadNameDeterminer.CURRENT);
        InetSocketAddress address = this.m_host == null ? new InetSocketAddress(this.m_port) : new InetSocketAddress(this.m_host, this.m_port);
        if (this.m_threadNamePrefix == null) {
            String className = new Exception().getStackTrace()[2].getClassName();
            int pos = className.lastIndexOf(46);
            name = className.substring(pos + 1);
        } else {
            name = this.m_threadNamePrefix;
        }
        if (this.m_maxThreads > 0) {
            bossExecutor = Threads.forPool().getFixedThreadPool(name + "Boss" + address, this.m_maxThreads);
            ExecutorService workerExecutor = Threads.forPool().getFixedThreadPool(name + "Worker", this.m_maxThreads);
            factory = new NioServerSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
        } else {
            bossExecutor = Threads.forPool().getCachedThreadPool(name + "Boss-" + address);
            ExecutorService workerExecutor = Threads.forPool().getCachedThreadPool(name + "Worker");
            factory = new NioServerSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
        }
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                return Channels.pipeline((org.jboss.netty.channel.ChannelHandler[])new org.jboss.netty.channel.ChannelHandler[]{new MessageDecoder(), new ChannelHandler()});
            }
        });
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        bootstrap.bind((SocketAddress)address);
        this.m_bootstrap = bootstrap;
        this.m_logger.info(this.m_threadNamePrefix + " is listening at " + address);
    }

    public static class MessageDecoder
    extends FrameDecoder {
        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) {
            int readableBytes = buffer.readableBytes();
            if (readableBytes < 4) {
                return null;
            }
            buffer.markReaderIndex();
            int length = buffer.readInt();
            buffer.resetReaderIndex();
            if (readableBytes < length + 4) {
                return null;
            }
            return buffer.readBytes(length + 4);
        }
    }

    class ChannelHandler
    extends SimpleChannelHandler {
        ChannelHandler() {
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent event) throws Exception {
            MessageReceiver.this.m_channelGroup.add((Object)event.getChannel());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
            MessageReceiver.this.m_logger.warn(event.getChannel().toString(), event.getCause());
            event.getChannel().close();
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
            ChannelBuffer buffer = (ChannelBuffer)event.getMessage();
            MessageReceiver.this.m_delegate.onMessageReceived(buffer);
        }
    }
}

