/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.plexus.logging.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.unidal.helper.Threads;
import org.unidal.lookup.logger.LoggerFactory;
import org.unidal.net.MessageDelegate;
import org.unidal.net.MessageReceiver;

@Deprecated
class MessageSender
implements Threads.Task {
    private MessageDelegate m_delegate;
    private int m_port;
    private String[] m_servers;
    private int m_maxThreads;
    private String m_threadNamePrefix;
    private FailoverChannelManager m_manager;
    private Logger m_logger = LoggerFactory.getLogger(MessageReceiver.class);
    private boolean m_active;
    private AtomicInteger m_attempts = new AtomicInteger();

    public MessageSender(MessageDelegate delegate, int port, String ... servers) {
        this.m_delegate = delegate;
        this.m_port = port;
        this.m_servers = servers;
    }

    public void setMaxThreads(int maxThreads) {
        this.m_maxThreads = maxThreads;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.m_threadNamePrefix = threadNamePrefix;
    }

    public void startClient() {
        String name;
        this.m_active = true;
        this.m_manager = new FailoverChannelManager();
        if (this.m_threadNamePrefix == null) {
            String className = new Exception().getStackTrace()[2].getClassName();
            int pos = className.lastIndexOf(46);
            name = className.substring(pos + 1);
        } else {
            name = this.m_threadNamePrefix;
        }
        Threads.forGroup(name).start(this);
        Threads.forGroup(name).start(this.m_manager);
    }

    private boolean checkWritable(ChannelFuture future) {
        boolean isWriteable = false;
        if (future != null && future.getChannel().isOpen()) {
            if (future.getChannel().isWritable()) {
                isWriteable = true;
            } else {
                int count = this.m_attempts.incrementAndGet();
                if (count % 1000 == 0 || count == 1) {
                    this.m_logger.error("Netty write buffer is full! Attempts: " + count + ".");
                }
            }
        }
        return isWriteable;
    }

    @Override
    public void run() {
        this.m_active = true;
        while (this.m_active) {
            ChannelFuture future = this.m_manager.getChannel();
            if (this.checkWritable(future)) {
                try {
                    ChannelBuffer buffer = this.m_delegate.nextMessage(5L, TimeUnit.MILLISECONDS);
                    if (buffer == null) continue;
                    Channel channel = future.getChannel();
                    channel.write((Object)buffer);
                }
                catch (Throwable t) {
                    this.m_logger.error("Error when sending message over TCP socket!", t);
                }
                continue;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(5L);
            }
            catch (Exception e) {
                this.m_active = false;
            }
        }
        this.m_manager.shutdown();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void shutdown() {
        this.m_active = false;
        this.m_manager.shutdown();
    }

    static class ExceptionHandler
    extends SimpleChannelHandler {
        private Logger m_logger;

        public ExceptionHandler(Logger logger) {
            this.m_logger = logger;
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            this.m_logger.warn("Channel disconnected by remote address: " + e.getChannel().getRemoteAddress());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            e.getChannel().close();
        }
    }

    class FailoverChannelManager
    implements Threads.Task {
        private List<InetSocketAddress> m_serverAddresses;
        private ClientBootstrap m_bootstrap;
        private ChannelFuture m_activeFuture;
        private int m_activeIndex;
        private ChannelFuture m_lastFuture;
        private AtomicInteger m_reconnects = new AtomicInteger(999);

        public FailoverChannelManager() {
            NioClientSocketChannelFactory factory;
            String[] workerExecutor;
            ExecutorService bossExecutor;
            if (MessageSender.this.m_maxThreads > 0) {
                bossExecutor = Threads.forPool().getFixedThreadPool(MessageSender.this.m_threadNamePrefix + "-Boss", 10);
                workerExecutor = Threads.forPool().getFixedThreadPool(MessageSender.this.m_threadNamePrefix + "-Worker", 10);
                factory = new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
            } else {
                bossExecutor = Threads.forPool().getCachedThreadPool(MessageSender.this.m_threadNamePrefix + "-Boss");
                workerExecutor = Threads.forPool().getCachedThreadPool(MessageSender.this.m_threadNamePrefix + "-Worker");
                factory = new NioClientSocketChannelFactory((Executor)bossExecutor, (Executor)workerExecutor);
            }
            ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)factory);
            bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

                public ChannelPipeline getPipeline() {
                    return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new ExceptionHandler(MessageSender.this.m_logger)});
                }
            });
            bootstrap.setOption("tcpNoDelay", (Object)true);
            bootstrap.setOption("keepAlive", (Object)true);
            this.m_bootstrap = bootstrap;
            this.m_serverAddresses = new ArrayList<InetSocketAddress>();
            for (String server : MessageSender.this.m_servers) {
                this.m_serverAddresses.add(new InetSocketAddress(server, MessageSender.this.m_port));
            }
            int len = MessageSender.this.m_servers.length;
            for (int i = 0; i < len; ++i) {
                ChannelFuture future = this.createChannel(i);
                if (future == null) continue;
                this.m_activeFuture = future;
                this.m_activeIndex = i;
                break;
            }
        }

        ChannelFuture createChannel(int index) {
            InetSocketAddress address = this.m_serverAddresses.get(index);
            ChannelFuture future = this.m_bootstrap.connect((SocketAddress)address);
            future.awaitUninterruptibly(100L, TimeUnit.MILLISECONDS);
            if (!future.isSuccess()) {
                future.getChannel().getCloseFuture().awaitUninterruptibly(100L, TimeUnit.MILLISECONDS);
                int count = this.m_reconnects.incrementAndGet();
                if (count % 1000 == 0) {
                    MessageSender.this.m_logger.error("Error when connecting to " + address + ", message: " + future.getCause() + ", " + count);
                }
                return null;
            }
            MessageSender.this.m_logger.info("Connected to " + address + ".");
            return future;
        }

        public ChannelFuture getChannel() {
            if (this.m_lastFuture != null && this.m_lastFuture != this.m_activeFuture) {
                this.m_lastFuture.getChannel().close();
                this.m_lastFuture = null;
            }
            return this.m_activeFuture;
        }

        @Override
        public String getName() {
            return "MessageSender-ChannelManager";
        }

        @Override
        public void run() {
            try {
                while (MessageSender.this.m_active) {
                    try {
                        if (this.m_activeFuture != null && !this.m_activeFuture.getChannel().isOpen()) {
                            this.m_activeIndex = this.m_serverAddresses.size();
                        }
                        for (int i = 0; i < this.m_activeIndex; ++i) {
                            ChannelFuture future = this.createChannel(i);
                            if (future == null) continue;
                            this.m_lastFuture = this.m_activeFuture;
                            this.m_activeFuture = future;
                            this.m_activeIndex = i;
                            break;
                        }
                    }
                    catch (Throwable e) {
                        MessageSender.this.m_logger.error("Error happened in ChannelManager.", e);
                    }
                    Thread.sleep(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void shutdown() {
            MessageSender.this.m_active = false;
            if (this.m_activeFuture != null) {
                this.m_activeFuture.getChannel().close();
                this.m_activeFuture = null;
            }
            this.m_bootstrap.getFactory().releaseExternalResources();
        }
    }
}

