/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net;

import java.util.ArrayList;
import java.util.List;
import org.unidal.net.MessageDelegate;
import org.unidal.net.MessageReceiver;
import org.unidal.net.MessageSender;
import org.unidal.net.SocketClientManager;
import org.unidal.net.SocketHandler;
import org.unidal.net.SocketServerManager;

public class Sockets {
    public static Client asClient() {
        return new Client();
    }

    public static Server asServer() {
        return new Server();
    }

    @Deprecated
    public static SocketClient forClient() {
        return new SocketClient();
    }

    @Deprecated
    public static SocketServer forServer() {
        return new SocketServer();
    }

    @Deprecated
    public static class SocketServer {
        private String m_host;
        private int m_port;
        private MessageReceiver m_receiver;
        private int m_maxThreads;
        private String m_threadNamePrefix;

        public SocketServer listenOn(int port) {
            this.m_port = port;
            return this;
        }

        public SocketServer listenOn(String host, int port) {
            this.m_host = host;
            this.m_port = port;
            return this;
        }

        public void shutdown() {
            if (this.m_receiver == null) {
                throw new IllegalStateException("Socket server is not started yet!");
            }
            this.m_receiver.shutdown();
        }

        public SocketServer start(MessageDelegate delegate) {
            this.m_receiver = new MessageReceiver(delegate, this.m_port, this.m_host);
            this.m_receiver.setThreadNamePrefix(this.m_threadNamePrefix);
            this.m_receiver.setMaxThreads(this.m_maxThreads);
            this.m_receiver.startServer();
            return this;
        }

        public SocketServer threads(String threadNamePrefix, int maxThreads) {
            this.m_threadNamePrefix = threadNamePrefix;
            this.m_maxThreads = maxThreads;
            return this;
        }
    }

    @Deprecated
    public static class SocketClient {
        private int m_port;
        private String[] m_servers;
        private MessageSender m_sender;
        private int m_maxThreads;
        private String m_threadNamePrefix;

        public SocketClient connectTo(int port, String ... servers) {
            this.m_port = port;
            this.m_servers = servers;
            return this;
        }

        public void shutdown() {
            this.m_sender.shutdown();
        }

        public SocketClient start(MessageDelegate delegate) {
            this.m_sender = new MessageSender(delegate, this.m_port, this.m_servers);
            this.m_sender.setThreadNamePrefix(this.m_threadNamePrefix);
            this.m_sender.setMaxThreads(this.m_maxThreads);
            this.m_sender.startClient();
            return this;
        }

        public SocketClient threads(String threadNamePrefix, int maxThreads) {
            this.m_threadNamePrefix = threadNamePrefix;
            this.m_maxThreads = maxThreads;
            return this;
        }
    }

    public static class Server {
        private String m_host;
        private int m_port;
        private SocketServerManager m_server;
        private int m_maxThreads;
        private String m_threadNamePrefix;

        public Server listenOn(int port) {
            this.m_port = port;
            return this;
        }

        public Server listenOn(String host, int port) {
            this.m_host = host;
            this.m_port = port;
            return this;
        }

        public void shutdown() {
            if (this.m_server == null) {
                throw new IllegalStateException("Socket server is not started yet!");
            }
            this.m_server.shutdown();
        }

        public Server start(SocketHandler handler) {
            this.m_server = new SocketServerManager(handler, this.m_port, this.m_host);
            this.m_server.setThreadNamePrefix(this.m_threadNamePrefix);
            this.m_server.setMaxThreads(this.m_maxThreads);
            this.m_server.start();
            return this;
        }

        public Server threads(String threadNamePrefix, int maxThreads) {
            this.m_threadNamePrefix = threadNamePrefix;
            this.m_maxThreads = maxThreads;
            return this;
        }
    }

    public static class Client {
        private List<Integer> m_ports = new ArrayList<Integer>();
        private List<String> m_servers = new ArrayList<String>();
        private SocketClientManager m_client;
        private int m_maxThreads;
        private String m_threadNamePrefix;
        private int m_checkInterval = 1000;

        public Client checkInterval(int checkInterval) {
            if (checkInterval > 0) {
                this.m_checkInterval = checkInterval;
            }
            return this;
        }

        public Client connectTo(String server, int port) {
            this.m_ports.add(port);
            this.m_servers.add(server);
            return this;
        }

        public void shutdown() {
            this.m_client.shutdown();
        }

        public Client start(SocketHandler handler) {
            this.m_client = new SocketClientManager(handler, this.m_ports, this.m_servers);
            this.m_client.setThreadNamePrefix(this.m_threadNamePrefix);
            this.m_client.setMaxThreads(this.m_maxThreads);
            this.m_client.setCheckInterval(this.m_checkInterval);
            this.m_client.start();
            return this;
        }

        public Client threads(String threadNamePrefix, int maxThreads) {
            this.m_threadNamePrefix = threadNamePrefix;
            this.m_maxThreads = maxThreads;
            return this;
        }
    }
}

