/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.api.remoteservice.activity.RemoteAnticheatLotteryCheckService;
import cn.com.duiba.anticheat.center.api.result.activity.ALCResultDto;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryBlackConsumerStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryLessOneSecStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryNotMobileStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotterySameDeapStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotterySameIpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotterySameUaCreditsStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryTongDunHighStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryWhiteIpStrategy;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteAnticheatLotteryCheckService")
public class RemoteAnticheatLotteryCheckServiceImpl
implements InitializingBean,
RemoteAnticheatLotteryCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAnticheatLotteryCheckServiceImpl.class);
    private List<AnticheatLotteryStrategy> blackStrategies = new ArrayList<AnticheatLotteryStrategy>();
    private List<AnticheatLotteryStrategy> whiteStrategies = new ArrayList<AnticheatLotteryStrategy>();
    @Autowired
    private ExecutorService executorService;
    private static final int TIMEOUT_TIME = 80;
    private static final Semaphore SEMAPHORE = new Semaphore(90);
    @Autowired
    private AnticheatLotteryLessOneSecStrategy anticheatLotteryLessOneSecStrategy;
    @Autowired
    private AnticheatLotterySameDeapStrategy anticheatLotterySameDeapStrategy;
    @Autowired
    private AnticheatLotterySameIpStrategy anticheatLotterySameIpStrategy;
    @Autowired
    private AnticheatLotteryBlackConsumerStrategy anticheatLotteryBlackConsumerStrategy;
    @Autowired
    private AnticheatLotteryNotMobileStrategy anticheatLotteryNotMobileStrategy;
    @Autowired
    private AnticheatLotterySameUaCreditsStrategy anticheatLotterySameUaCreditsStrategy;
    @Autowired
    private AnticheatLotteryTongDunHighStrategy anticheatLotteryTongDunHighStrategy;
    @Autowired
    private AnticheatLotteryWhiteIpStrategy anticheatLotteryWhiteIpStrategy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<ALCResultDto> checkLottery(final LotteryConsumerParams consumer, final LotteryOrderParams order, final LotteryRequestParams request) {
        Callable<DubboResult<ALCResultDto>> callable = new Callable<DubboResult<ALCResultDto>>(){

            @Override
            public DubboResult<ALCResultDto> call() throws Exception {
                FraudApiResponse response = TongdunClient.checkLotteryTongdun(consumer, order, request);
                TongdunThreadLocal.get().setApiResponse(response);
                ALCResultDto result = RemoteAnticheatLotteryCheckServiceImpl.this.innerCheckLottery(consumer, order, request);
                return DubboResult.successResult((Object)result);
            }
        };
        DubboResult successResult = DubboResult.successResult((Object)new ALCResultDto(Boolean.valueOf(true), null));
        if (SEMAPHORE.tryAcquire()) {
            try {
                Future<DubboResult<ALCResultDto>> future = this.executorService.submit(callable);
                DubboResult result = future.get(80L, TimeUnit.MILLISECONDS);
                DubboResult dubboResult = result != null ? result : successResult;
                return dubboResult;
            }
            catch (Exception e) {
                LOGGER.warn("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,{}", (Object)e.getMessage());
                DubboResult dubboResult = successResult;
                return dubboResult;
            }
            finally {
                SEMAPHORE.release();
            }
        }
        LOGGER.warn("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, lotteryOrderId={}, type={}, appId={}, consumerId={}", new Object[]{order.getLotteryOrderId(), order.getType().desc(), consumer.getAppId(), consumer.getConsumerId()});
        return successResult;
    }

    private ALCResultDto innerCheckLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        AnticheatLotteryStrategy.AnticheatLotteryStrategyResult ret;
        Transaction t;
        for (AnticheatLotteryStrategy as : this.whiteStrategies) {
            t = Cat.newTransaction((String)"URL", (String)as.getClass().getSimpleName());
            try {
                ret = as.checkLottery(consumer, order, request);
                t.setStatus("0");
                if (!ret.isMatch() || !as.isEnable()) continue;
                ALCResultDto aLCResultDto = new ALCResultDto(Boolean.valueOf(true), "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                return aLCResultDto;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                throw e;
            }
            finally {
                t.complete();
            }
        }
        for (AnticheatLotteryStrategy as : this.blackStrategies) {
            t = Cat.newTransaction((String)"URL", (String)as.getClass().getSimpleName());
            try {
                ret = as.checkLottery(consumer, order, request);
                t.setStatus("0");
                if (!ret.isMatch() || !as.isEnable() || as.getEffectMode() == 0 && !as.isAppEnable(consumer.getAppId())) continue;
                ALCResultDto aLCResultDto = new ALCResultDto(Boolean.valueOf(false), "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                return aLCResultDto;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                throw e;
            }
            finally {
                t.complete();
            }
        }
        return new ALCResultDto(Boolean.valueOf(true), null);
    }

    public void afterPropertiesSet() throws Exception {
        this.blackStrategies.add(this.anticheatLotteryTongDunHighStrategy);
        this.blackStrategies.add(this.anticheatLotteryLessOneSecStrategy);
        this.blackStrategies.add(this.anticheatLotterySameDeapStrategy);
        this.blackStrategies.add(this.anticheatLotteryBlackConsumerStrategy);
        this.blackStrategies.add(this.anticheatLotterySameIpStrategy);
        this.blackStrategies.add(this.anticheatLotteryNotMobileStrategy);
        this.blackStrategies.add(this.anticheatLotterySameUaCreditsStrategy);
        this.whiteStrategies.add(this.anticheatLotteryWhiteIpStrategy);
    }
}

