/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.OrderParams;
import cn.com.duiba.anticheat.center.api.remoteservice.goods.RemoteAnticheatAlarmService;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatAlarmConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.AnticheatAlarmConfigService;
import cn.com.duiba.anticheat.center.biz.service.SmsRemindService;
import cn.com.duiba.anticheat.center.common.exceptions.SmsException;
import cn.com.duiba.boot.ext.autoconfigure.logger.JsonLoggerFactory;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteAnticheatAlarmService")
public class RemoteAnticheatAlarmServiceImpl
implements RemoteAnticheatAlarmService {
    private static final Logger LOGGER = JsonLoggerFactory.getLogger(RemoteAnticheatAlarmServiceImpl.class);
    private static final Map<String, Integer> couponExchangeMap = new ConcurrentHashMap<String, Integer>();
    @Autowired
    private AnticheatAlarmConfigService anticheatAlarmConfigService;
    @Autowired
    private SmsRemindService smsRemindService;

    public static Map<String, Integer> getCouponExchangeMap() {
        return couponExchangeMap;
    }

    public DubboResult<Void> onOrderSuccess(OrderParams order) {
        try {
            this.addExchangeTimes(order.getAppId(), order.getItemId());
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOGGER.error(String.format("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, orderId=%s, appId=%s, itemId=%s", order.getOrderId(), order.getAppId(), order.getItemId()), (Throwable)e);
            return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
    }

    private void addExchangeTimes(Long appId, Long itemId) throws IOException, SmsException {
        if (appId == null || itemId == null) {
            return;
        }
        String key = appId + "-" + itemId;
        AnticheatAlarmConfigEntity config = this.anticheatAlarmConfigService.getCacheConfig("app-item-alarm");
        Integer value = couponExchangeMap.get(key);
        int threshold = config.getThreshold();
        if (value == null) {
            couponExchangeMap.put(key, 1);
            return;
        }
        if ((value = Integer.valueOf(value + 1)) == threshold) {
            String message = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdappId=" + appId + ", itemId=" + itemId + ", \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd=" + DateUtils.getSecondStr((Date)new Date()) + ", \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + config.getCircle() + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd=" + value;
            this.smsRemindService.alarm(config.getPhone(), message);
        }
        couponExchangeMap.put(key, value);
    }
}

