/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.remoteservice.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.OrderParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.api.remoteservice.goods.RemoteAnticheatCheckService;
import cn.com.duiba.anticheat.center.api.result.goods.ACResultDto;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatBlackConsumerStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatBlackIpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatConsumerDayTimesStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatFirstInTimesStartegy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatFirstNoSwipeStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatFirstSameUaCreditsStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatIpDayTimesStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameCreditsAddUpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameCreditsStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameDeapStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSameIpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatSwipeSkipStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatTongDunHighStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatTongDunMiddleStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatWhiteIpStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatWhiteItemStrategy;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.IntegerTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteAnticheatCheckService")
public class RemoteAnticheatCheckServiceImpl
implements InitializingBean,
RemoteAnticheatCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAnticheatCheckServiceImpl.class);
    private static final int CIRCLE = 5;
    private List<AnticheatStrategy> whiteStrategies = new ArrayList<AnticheatStrategy>();
    private List<AnticheatStrategy> blackStrategies = new ArrayList<AnticheatStrategy>();
    private static final int TIMEOUT_TIME = 90;
    private static final Semaphore SEMAPHORE = new Semaphore(10);
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Autowired
    private MemcachedClient memcachedClient;
    @Autowired
    private AnticheatBlackIpStrategy anticheatBlackIpStrategy;
    @Autowired
    private AnticheatWhiteIpStrategy anticheatWhiteIpStrategy;
    @Autowired
    private AnticheatSameCreditsStrategy anticheatSameCreditsStrategy;
    @Autowired
    private AnticheatIpDayTimesStrategy anticheatIpDayTimesStrategy;
    @Autowired
    private AnticheatConsumerDayTimesStrategy anticheatConsumerDayTimesStrategy;
    @Autowired
    private AnticheatSwipeSkipStrategy anticheatSwipeSkipStrategy;
    @Autowired
    private AnticheatSameDeapStrategy anticheatSameDeapStrategy;
    @Autowired
    private AnticheatFirstInTimesStartegy anticheatFirstInTimesStartegy;
    @Autowired
    private AnticheatFirstNoSwipeStrategy anticheatFirstNoSwipeStrategy;
    @Autowired
    private AnticheatSameCreditsAddUpStrategy anticheatSameCreditsAddUpStrategy;
    @Autowired
    private AnticheatSameIpStrategy anticheatSameIpStrategy;
    @Autowired
    private AnticheatBlackConsumerStrategy anticheatBlackConsumerStrategy;
    @Autowired
    private AnticheatFirstSameUaCreditsStrategy anticheatFirstSameUaCreditsStrategy;
    @Autowired
    private AnticheatWhiteItemStrategy anticheatWhiteItemStrategy;
    @Autowired
    private AnticheatTongDunMiddleStrategy anticheatTongDunMiddleStrategy;
    @Autowired
    private AnticheatTongDunHighStrategy anticheatTongDunHighStrategy;

    private String getIpKey(String ip) {
        return "103-ip-" + ip;
    }

    private String getConsumerKey(Long cid) {
        return "103-cid-" + cid;
    }

    public DubboResult<Void> onOrderCreate(OrderParams order) {
        try {
            if (this.setByCas(this.getIpKey(order.getIp()), 1) == 2) {
                this.memcachedClient.add(this.getIpKey(order.getIp()), DateUtils.getToTomorrowSeconds(), (Object)1);
            }
            if (this.setByCas(this.getConsumerKey(order.getConsumerId()), 1) == 2) {
                this.memcachedClient.add(this.getConsumerKey(order.getConsumerId()), DateUtils.getToTomorrowSeconds(), (Object)1);
            }
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOGGER.error("onOrderCreate, error", (Throwable)e);
            return DubboResult.failResult((String)"onOrderCreate, error");
        }
    }

    public DubboResult<Void> onOrderFail(OrderParams order) {
        try {
            this.setByCas(this.getIpKey(order.getIp()), -1);
            this.setByCas(this.getConsumerKey(order.getConsumerId()), -1);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOGGER.error("onOrderFail, error", (Throwable)e);
            return DubboResult.failResult((String)"onOrderFail, \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
    }

    private Integer setByCas(String key, int type) {
        Integer result = null;
        boolean loop = true;
        try {
            int loopNum = 0;
            while (loop) {
                if (loopNum >= 10) {
                    loop = false;
                    result = 1;
                    break;
                }
                CASValue last = this.memcachedClient.gets(key);
                if (last == null) {
                    loop = false;
                    result = 2;
                    break;
                }
                int nextValue = (Integer)last.getValue();
                if (type > 0) {
                    ++nextValue;
                } else {
                    if (type >= 0) {
                        loop = false;
                        result = 4;
                        break;
                    }
                    --nextValue;
                }
                CASResponse caseResponse = this.memcachedClient.cas(key, last.getCas(), DateUtils.getToTomorrowSeconds(), (Object)nextValue, (Transcoder)new IntegerTranscoder());
                switch (caseResponse) {
                    case OK: {
                        loop = false;
                        result = 0;
                        break;
                    }
                    case NOT_FOUND: {
                        loop = false;
                        result = 2;
                        break;
                    }
                    case EXISTS: {
                        loop = true;
                    }
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            result = 5;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DubboResult<ACResultDto> checkCouponExchange(final ConsumerParams consumer, final GoodsParams goods, final RequestParams request, final BehaviorParams behavior) {
        Callable<DubboResult<ACResultDto>> callable = new Callable<DubboResult<ACResultDto>>(){

            @Override
            public DubboResult<ACResultDto> call() throws Exception {
                FraudApiResponse response = TongdunClient.checkExchangeTongdun(consumer, goods, request, behavior);
                TongdunThreadLocal.get().setApiResponse(response);
                ACResultDto result = RemoteAnticheatCheckServiceImpl.this.innerCheckCouponExchange(consumer, goods, request, behavior);
                return DubboResult.successResult((Object)result);
            }
        };
        DubboResult successResult = DubboResult.successResult((Object)new ACResultDto(true, null, null, Integer.valueOf(0)));
        if (SEMAPHORE.tryAcquire()) {
            try {
                Future<DubboResult<ACResultDto>> future = this.executorService.submit(callable);
                DubboResult result = future.get(90L, TimeUnit.MILLISECONDS);
                DubboResult dubboResult = result != null ? result : successResult;
                return dubboResult;
            }
            catch (Exception e) {
                LOGGER.warn("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,{}", (Object)e.getMessage());
                DubboResult dubboResult = successResult;
                return dubboResult;
            }
            finally {
                SEMAPHORE.release();
            }
        }
        LOGGER.warn("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdconsumerId={}, gtype={}, gid={}", new Object[]{consumer.getConsumerId(), goods.getGtype(), goods.getGid()});
        return successResult;
    }

    public DubboResult<Void> fillbackDebugIds(List<Long> debugIds, Long orderId) {
        try {
            AnticheatDebugLogEntity debug = null;
            for (Long it : debugIds) {
                debug = new AnticheatDebugLogEntity(it);
                debug.setOrderId(orderId);
                this.anticheatDebugLogDao.update(debug);
            }
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            LOGGER.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd dubugIds \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd debugIds \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
    }

    private ACResultDto innerCheckCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        AnticheatStrategy.AnticheatStrategyResult ret;
        Transaction t;
        ArrayList<Long> debugIds = new ArrayList<Long>();
        for (AnticheatStrategy as : this.whiteStrategies) {
            t = Cat.newTransaction((String)"URL", (String)as.getClass().getSimpleName());
            try {
                ret = as.checkCouponExchange(consumer, goods, request, behavior);
                t.setStatus("0");
                if (!ret.isMatch()) continue;
                if (as.isEnable() && as.isAppEnable(consumer.getAppId())) {
                    ACResultDto aCResultDto = new ACResultDto(true, "", Arrays.asList(ret.getDebugId()), Integer.valueOf(0));
                    return aCResultDto;
                }
                debugIds.add(ret.getDebugId());
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                throw e;
            }
            finally {
                t.complete();
            }
        }
        for (AnticheatStrategy as : this.blackStrategies) {
            t = Cat.newTransaction((String)"URL", (String)as.getClass().getSimpleName());
            try {
                ret = as.checkCouponExchange(consumer, goods, request, behavior);
                t.setStatus("0");
                if (!ret.isMatch()) continue;
                if (!as.isEnable()) {
                    debugIds.add(ret.getDebugId());
                    continue;
                }
                if (as.getEffectMode() == 0 && !as.isAppEnable(consumer.getAppId())) {
                    debugIds.add(ret.getDebugId());
                    continue;
                }
                if (as.getCheckMode() == 0) {
                    ACResultDto aCResultDto = new ACResultDto(false, "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", Arrays.asList(ret.getDebugId()), Integer.valueOf(0));
                    return aCResultDto;
                }
                if (as.getCheckMode() != 1) continue;
                ACResultDto aCResultDto = new ACResultDto(false, "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", Arrays.asList(ret.getDebugId()), Integer.valueOf(1));
                return aCResultDto;
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
                throw e;
            }
            finally {
                t.complete();
            }
        }
        return new ACResultDto(true, null, debugIds, Integer.valueOf(0));
    }

    public void afterPropertiesSet() throws Exception {
        this.blackStrategies.add(this.anticheatTongDunMiddleStrategy);
        this.blackStrategies.add(this.anticheatTongDunHighStrategy);
        this.blackStrategies.add(this.anticheatBlackIpStrategy);
        this.blackStrategies.add(this.anticheatSameCreditsStrategy);
        this.blackStrategies.add(this.anticheatIpDayTimesStrategy);
        this.blackStrategies.add(this.anticheatConsumerDayTimesStrategy);
        this.blackStrategies.add(this.anticheatSwipeSkipStrategy);
        this.blackStrategies.add(this.anticheatSameDeapStrategy);
        this.blackStrategies.add(this.anticheatFirstInTimesStartegy);
        this.blackStrategies.add(this.anticheatFirstNoSwipeStrategy);
        this.blackStrategies.add(this.anticheatSameCreditsAddUpStrategy);
        this.blackStrategies.add(this.anticheatSameIpStrategy);
        this.blackStrategies.add(this.anticheatBlackConsumerStrategy);
        this.blackStrategies.add(this.anticheatFirstSameUaCreditsStrategy);
        this.whiteStrategies.add(this.anticheatWhiteIpStrategy);
        this.whiteStrategies.add(this.anticheatWhiteItemStrategy);
        this.sortScheduler();
    }

    public List<AnticheatStrategy> sortBlackStrategies(List<AnticheatStrategy> list) {
        Collections.sort(list, new Comparator<AnticheatStrategy>(){

            @Override
            public int compare(AnticheatStrategy o1, AnticheatStrategy o2) {
                int ib = this.compareBoolean(o1.isEnable(), o2.isEnable());
                if (ib != 0) {
                    return ib;
                }
                return this.compareInt(o1.getCheckMode(), o2.getCheckMode());
            }

            private int compareInt(int i1, int i2) {
                if (i1 == i2) {
                    return 0;
                }
                if (i1 == 0) {
                    return -1;
                }
                return 1;
            }

            private int compareBoolean(boolean b1, boolean b2) {
                if (b1 == b2) {
                    return 0;
                }
                if (b1) {
                    return -1;
                }
                return 1;
            }
        });
        return list;
    }

    private void sortScheduler() {
        ScheduledExecutorService executor = TtlExecutors.getTtlScheduledExecutorService((ScheduledExecutorService)Executors.newScheduledThreadPool(1));
        executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ArrayList<AnticheatStrategy> newList = new ArrayList<AnticheatStrategy>(RemoteAnticheatCheckServiceImpl.this.blackStrategies);
                RemoteAnticheatCheckServiceImpl.this.blackStrategies = RemoteAnticheatCheckServiceImpl.this.sortBlackStrategies(newList);
                LOGGER.info("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd~");
            }
        }, 0L, 5L, TimeUnit.MINUTES);
    }
}

