/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.scheduler;

import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatAlarmConfigEntity;
import cn.com.duiba.anticheat.center.biz.remoteservice.goods.impl.RemoteAnticheatAlarmServiceImpl;
import cn.com.duiba.anticheat.center.biz.service.AnticheatAlarmConfigService;
import cn.com.duiba.anticheat.center.biz.service.SmsRemindService;
import cn.com.duiba.boot.ext.autoconfigure.logger.JsonLoggerFactory;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlarmScheduler
implements InitializingBean {
    private static final Logger LOGGER = JsonLoggerFactory.getLogger(AlarmScheduler.class);
    @Autowired
    private AnticheatAlarmConfigService anticheatAlarmConfigService;
    @Autowired
    private SmsRemindService smsRemindService;

    public void afterPropertiesSet() throws Exception {
        this.alarmScheduler();
    }

    private void alarmScheduler() {
        final AnticheatAlarmConfigEntity config = this.anticheatAlarmConfigService.getCacheConfig("app-item-alarm");
        ScheduledExecutorService executor = TtlExecutors.getTtlScheduledExecutorService((ScheduledExecutorService)Executors.newScheduledThreadPool(1));
        final int circle = config.getCircle();
        executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                int threshold = config.getThreshold();
                for (Map.Entry<String, Integer> entry : RemoteAnticheatAlarmServiceImpl.getCouponExchangeMap().entrySet()) {
                    if (entry.getValue() < threshold) continue;
                    String[] args = entry.getKey().split("-");
                    String message = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdappId=" + args[0] + ", itemId=" + args[1] + ", \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd=" + DateUtils.getSecondStr((Date)new Date()) + ", " + circle + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd=" + entry.getValue();
                    try {
                        AlarmScheduler.this.smsRemindService.alarm(config.getPhone(), message);
                    }
                    catch (Exception e) {
                        LOGGER.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd," + message, (Throwable)e);
                    }
                }
                RemoteAnticheatAlarmServiceImpl.getCouponExchangeMap().clear();
            }
        }, 0L, circle, TimeUnit.MINUTES);
    }
}

