/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryStrategyConfigService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatLotteryNotMobileStrategy
implements AnticheatLotteryStrategy {
    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;
    @Autowired
    private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

    @Override
    public int getEffectMode() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("not-mobile").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("not-mobile").getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = this.anticheatLotteryStrategyConfigService.getCacheAppConfig("not-mobile");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatLotteryStrategy.AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        String ua = this.getOS(request.getUserAgent());
        if (!this.checkUa(ua)) {
            Long debugId = this.doMatchProcess(consumer, order, request);
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(true, debugId);
        }
        return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
    }

    private String getOS(String ua) {
        if (ua == null) {
            return "Unkonwn";
        }
        if ((ua = ua.toLowerCase()) != null) {
            if (ua.contains("ipad")) {
                return "iPad";
            }
            if (ua.contains("iphone")) {
                return "iPhone";
            }
            if (ua.contains("android")) {
                return "Android";
            }
            if (ua.contains("linux")) {
                return "Linux";
            }
            if (ua.contains("windows")) {
                return "Windows";
            }
            if (ua.contains("macintosh")) {
                return "Mac";
            }
        }
        return "Unknown";
    }

    private boolean checkUa(String ua) {
        if ("iPad".equals(ua)) {
            return true;
        }
        if ("iPhone".equals(ua)) {
            return true;
        }
        return "Android".equals(ua);
    }

    private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType("not-mobile");
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdiPhone, Android, iPad");
        this.anticheatLotteryDebugLogDao.insert(debug);
        return debug.getId();
    }
}

