/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryStrategyConfigService;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatLotterySameDeapStrategy
implements AnticheatLotteryStrategy {
    private static final HashMultimap<String, LotteryRecord> sameDeapMap = HashMultimap.create();
    private static final int CONSUMER_DEAP_LIMIT_COUNT = 1;
    private static final int MAP_SIZE = 10000;
    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;
    @Autowired
    private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

    @Override
    public int getEffectMode() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("same-deap").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("same-deap").getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = this.anticheatLotteryStrategyConfigService.getCacheAppConfig("same-deap");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatLotteryStrategy.AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        if (StringUtils.isBlank((CharSequence)request.getDeap())) {
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
        }
        LotteryRecord record = new LotteryRecord();
        record.setDeap(request.getDeap());
        record.setOperatingActivityId(order.getOperatingActivityId());
        record.setDuibaActivityId(order.getDuibaActivityId());
        record.setTime(new Date());
        record.setType(order.getType());
        record.setLotteryOrderId(order.getLotteryOrderId());
        record.setConsumerId(consumer.getConsumerId());
        record.setAppId(consumer.getAppId());
        String key = this.getKey(order.getOperatingActivityId(), request.getDeap());
        if (sameDeapMap.size() > 10000) {
            sameDeapMap.clear();
        }
        sameDeapMap.put((Object)key, (Object)record);
        Set records = sameDeapMap.get((Object)key);
        if (records == null) {
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
        }
        if (records.size() > 1) {
            Long debugId = this.doMatchProcess(consumer, order, request, records.size());
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(true, debugId);
        }
        return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
    }

    private String getKey(Long operatingActivityId, String deap) {
        return String.format("%s-%s", operatingActivityId, deap);
    }

    private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request, int count) {
        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType("same-deap");
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage(String.format("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd (%s) \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd %s \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd %s \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd(app\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdid: %s, duiba\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdid(\ufffd\ufffd\ufffdapp-\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdid): %s)", request.getDeap(), count, order.getType().desc(), order.getOperatingActivityId(), order.getDuibaActivityId()));
        this.anticheatLotteryDebugLogDao.insert(debug);
        return debug.getId();
    }

    private class LotteryRecord {
        private LotteryOrderParams.LotteryOrderTypeEnum type;
        private Long operatingActivityId;
        private Long duibaActivityId;
        private Date time;
        private String deap;
        private Long lotteryOrderId;
        private Long consumerId;
        private Long appId;

        private LotteryRecord() {
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.consumerId});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LotteryRecord)) {
                return false;
            }
            LotteryRecord o = (LotteryRecord)obj;
            return this.consumerId.equals(o.consumerId);
        }

        public LotteryOrderParams.LotteryOrderTypeEnum getType() {
            return this.type;
        }

        public void setType(LotteryOrderParams.LotteryOrderTypeEnum type) {
            this.type = type;
        }

        public Long getOperatingActivityId() {
            return this.operatingActivityId;
        }

        public void setOperatingActivityId(Long operatingActivityId) {
            this.operatingActivityId = operatingActivityId;
        }

        public Long getDuibaActivityId() {
            return this.duibaActivityId;
        }

        public void setDuibaActivityId(Long duibaActivityId) {
            this.duibaActivityId = duibaActivityId;
        }

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public String getDeap() {
            return this.deap;
        }

        public void setDeap(String deap) {
            this.deap = deap;
        }

        public Long getLotteryOrderId() {
            return this.lotteryOrderId;
        }

        public void setLotteryOrderId(Long lotteryOrderId) {
            this.lotteryOrderId = lotteryOrderId;
        }

        public Long getConsumerId() {
            return this.consumerId;
        }

        public void setConsumerId(Long consumerId) {
            this.consumerId = consumerId;
        }

        public Long getAppId() {
            return this.appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }
    }
}

