/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.service.tongdun.FraudApiResponse;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunClient;
import cn.com.duiba.anticheat.center.biz.service.tongdun.TongdunThreadLocal;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryStrategyConfigService;
import cn.com.duiba.boot.ext.autoconfigure.logger.JsonLoggerFactory;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatLotteryTongDunHighStrategy
implements AnticheatLotteryStrategy {
    private static final Logger LOGGER = JsonLoggerFactory.getLogger(AnticheatLotteryTongDunHighStrategy.class);
    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;
    @Autowired
    private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;

    @Override
    public int getEffectMode() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("tongdun-high").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("tongdun-high").getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = this.anticheatLotteryStrategyConfigService.getCacheAppConfig("tongdun-high");
        return map.containsKey(appId);
    }

    @Override
    public AnticheatLotteryStrategy.AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        if ("not_login".equals(consumer.getPartnerUserId())) {
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
        }
        try {
            FraudApiResponse response = TongdunThreadLocal.get().getApiResponse();
            if (response == null) {
                return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
            }
            if (TongdunClient.isReject(response)) {
                Long debugId = this.doMatchProcess(response, consumer, order, request);
                return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(true, debugId);
            }
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
        }
        catch (Exception e) {
            LOGGER.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,", (Throwable)e);
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
        }
    }

    private Long doMatchProcess(FraudApiResponse response, LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        String message = String.format("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd(type: %s, duibaActivityId: %s, operatingActivityId: %s)\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd%s", order.getType().desc(), order.getDuibaActivityId(), order.getOperatingActivityId(), response.getSeq_id());
        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType("tongdun-high");
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage(message);
        this.anticheatLotteryDebugLogDao.insert(debug);
        return debug.getId();
    }
}

