/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.activity.impl;

import cn.com.duiba.anticheat.center.api.domain.activity.LotteryConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryOrderParams;
import cn.com.duiba.anticheat.center.api.domain.activity.LotteryRequestParams;
import cn.com.duiba.anticheat.center.biz.dao.activity.AnticheatLotteryDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatIpLimitDao;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.activity.AnticheatLotteryStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatIpLimitEntity;
import cn.com.duiba.anticheat.center.biz.strategy.activity.AnticheatLotteryStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.activity.impl.AnticheatLotteryStrategyConfigService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatLotteryWhiteIpStrategy
implements AnticheatLotteryStrategy {
    @Autowired
    private AnticheatLotteryStrategyConfigService anticheatLotteryStrategyConfigService;
    @Autowired
    private AnticheatLotteryDebugLogDao anticheatLotteryDebugLogDao;
    @Autowired
    private AnticheatIpLimitDao anticheatIpLimitDao;

    @Override
    public int getEffectMode() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("white-ip").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatLotteryStrategyConfigService.getCacheConfig("white-ip").getEnable();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatLotteryStrategyAppConfigEntity> map = this.anticheatLotteryStrategyConfigService.getCacheAppConfig("white-ip");
        return map.containsKey(appId);
    }

    public AnticheatIpLimitEntity checkInWhiteList(String ip) {
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            AnticheatIpLimitEntity record = this.anticheatIpLimitDao.findEnableWhiteIp(ip);
            if (record != null) {
                return record;
            }
            String regionip = ip.substring(0, ip.lastIndexOf("."));
            record = this.anticheatIpLimitDao.findEnableWhiteIp(regionip);
            if (record != null) {
                return record;
            }
        }
        return null;
    }

    @Override
    public AnticheatLotteryStrategy.AnticheatLotteryStrategyResult checkLottery(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        AnticheatIpLimitEntity record;
        String ip = request.getIp();
        if (StringUtils.isNotBlank((CharSequence)ip) && (record = this.checkInWhiteList(ip)) != null) {
            Long debugId = this.doMatchProcess(consumer, order, request);
            return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(true, debugId);
        }
        return new AnticheatLotteryStrategy.AnticheatLotteryStrategyResult(false);
    }

    private Long doMatchProcess(LotteryConsumerParams consumer, LotteryOrderParams order, LotteryRequestParams request) {
        AnticheatLotteryDebugLogEntity debug = new AnticheatLotteryDebugLogEntity();
        debug.setStrategyType("white-ip");
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setLotteryOrderId(order.getLotteryOrderId());
        debug.setRelationId(order.getDuibaActivityId());
        debug.setRelationType(order.getType().value());
        debug.setOperatingActivityId(order.getOperatingActivityId());
        debug.setAppId(order.getAppId());
        debug.setMessage(String.format("\ufffd\ufffd\ufffd IP(%s) \ufffd\ufffd\ufffd ip \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ", request.getIp()));
        this.anticheatLotteryDebugLogDao.insert(debug);
        return debug.getId();
    }
}

