/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatIpLimitDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatIpLimitEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatBlackIpStrategy
implements AnticheatStrategy {
    @Autowired
    private AnticheatIpLimitDao anticheatIpLimitDao;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    public List<AnticheatIpLimitEntity> getList() {
        return this.anticheatIpLimitDao.findAllBlackList();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("black-ip").getEnable();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("black-ip").getCheckMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        return true;
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("black-ip").getEffectMode();
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        String ip = request.getIp();
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            AnticheatIpLimitEntity record = this.anticheatIpLimitDao.findEnableBlackIp(ip);
            if (record != null) {
                Long debugId = this.doMatchProcess(consumer, goods, request, record);
                return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
            }
            String regionip = ip.substring(0, ip.lastIndexOf("."));
            record = this.anticheatIpLimitDao.findEnableBlackIp(regionip);
            if (record != null) {
                Long debugId = this.doMatchProcess(consumer, goods, request, record);
                return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
            }
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request, AnticheatIpLimitEntity record) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("black-ip");
        debug.setMessage(String.format("\ufffd\ufffd\ufffdIP\ufffd\ufffd\ufffdIP\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd(%s, %s)", record.getIp(), record.getRemark()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }
}

