/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Map;
import net.spy.memcached.MemcachedClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatConsumerDayTimesStrategy
implements AnticheatStrategy {
    private static final int CONSUMER_VALVE = 6;
    @Autowired
    private MemcachedClient memcachedClient;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("consumer-day-times").getEnable();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("consumer-day-times").getCheckMode();
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("consumer-day-times").getEffectMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("consumer-day-times");
        return map.containsKey(appId);
    }

    private String getConsumerKey(Long cid) {
        return String.format("%s-cid-new-%s", 103, cid);
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        long ret;
        Long consumerId = consumer.getConsumerId();
        String key = this.getConsumerKey(consumerId);
        if (consumerId == null) {
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        String consumerCount = (String)this.memcachedClient.get(key);
        int consumerInt = 0;
        if (consumerCount != null) {
            consumerInt = Integer.valueOf(consumerCount);
        }
        if ((ret = this.memcachedClient.incr(key, 1)) < 0L) {
            this.memcachedClient.add(key, DateUtils.getToTomorrowSeconds(), (Object)"1");
        }
        if (++consumerInt > 6) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("consumer-day-times");
        debug.setMessage(String.format("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ID (%s),\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd %s \ufffd\ufffd\ufffd", consumer.getConsumerId(), 6));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }
}

