/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatSameCreditsAddUpStrategy
implements AnticheatStrategy {
    private static final Map<String, Integer> couponExchangeMap = new ConcurrentHashMap<String, Integer>();
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;

    public static void clearMap() {
        couponExchangeMap.clear();
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits-add-up").getEffectMode();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits-add-up").getCheckMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits-add-up").getEnable();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits-add-up").getEnable();
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Long gid;
        Long appId = consumer.getAppId();
        Long credits = consumer.getCredits();
        Integer gtype = goods.getGtype();
        Integer value = couponExchangeMap.get(this.getItemAppCreditsKey(gtype, gid = goods.getGid(), appId, credits));
        if (value == null) {
            value = 1;
            couponExchangeMap.put(this.getItemAppCreditsKey(gtype, gid, appId, credits), value);
        } else {
            value = value + 1;
            couponExchangeMap.put(this.getItemAppCreditsKey(gtype, gid, appId, credits), value);
        }
        if (value > 5) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("same-credits-add-up");
        debug.setMessage(String.format("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd appId: %s, gtype: %s, gid: %s, credits: %s, \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd5\ufffd\ufffd\ufffd", consumer.getAppId(), goods.getGtype(), goods.getGid(), consumer.getCredits()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }

    private String getItemAppCreditsKey(Integer gtype, Long gid, Long appId, Long credits) {
        return String.format("%s-%s-%s-%s", gtype, gid, appId, credits);
    }
}

