/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.spy.memcached.MemcachedClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatSameCreditsStrategy
implements AnticheatStrategy {
    private static final int RANGE_VALUE = 20;
    private static final int MATCH_VALUE = 4;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    private Map<String, Queue<Model>> data = new HashMap<String, Queue<Model>>();
    @Autowired
    private MemcachedClient memcachedClient;

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits").getEnable();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits").getCheckMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("same-credits");
        return map.containsKey(appId);
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-credits").getEffectMode();
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        if (consumer.getLastLogin() != null && new Date().getTime() - consumer.getLastLogin().getTime() > 120000L) {
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        String key = this.check(consumer, goods, request, behavior);
        if (key != null) {
            this.putBlackList(key, 7200);
        }
        if (this.isInBlackList(consumer.getAppId(), goods.getGtype(), goods.getGid(), consumer.getCredits())) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    public String check(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        Model model = new Model();
        model.appId = consumer.getAppId();
        model.credits = consumer.getCredits();
        model.consumerId = consumer.getConsumerId();
        model.ua = request.getUserAgent();
        model.gtype = goods.getGtype();
        model.gid = goods.getGid();
        String datakey = this.getDataKey(model.appId, model.gtype, model.gid);
        Queue<Model> queue = this.data.get(datakey);
        if (queue == null) {
            queue = new LinkedBlockingQueue<Model>();
            this.data.put(datakey, queue);
        }
        queue.offer(model);
        while (queue.size() > 20) {
            queue.poll();
        }
        int count = 0;
        Iterator it = queue.iterator();
        while (it.hasNext()) {
            if (!((Model)it.next()).equalsTo(model)) continue;
            ++count;
        }
        if (count > 4) {
            return this.getKey(model.appId, model.gtype, model.gid, model.credits);
        }
        return null;
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("same-credits");
        debug.setMessage("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd(" + consumer.getCredits() + ")");
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }

    private boolean isInBlackList(Long appId, Integer gtype, Long gid, Long credits) {
        String key = this.getKey(appId, gtype, gid, credits);
        Object o = this.memcachedClient.get(key);
        return o != null;
    }

    private void putBlackList(String key, int seconds) {
        this.memcachedClient.set(key, seconds, (Object)"1");
    }

    private String getDataKey(Long appId, Integer gtype, Long gid) {
        return String.format("%s-%s-%s", appId, gtype, gid);
    }

    private String getKey(Long appId, Integer gtype, Long gid, Long credits) {
        return String.format("%s-%s-%s-%s", appId, gtype, gid, credits);
    }

    private class Model {
        public Long appId;
        public Integer gtype;
        public Long gid;
        public Long credits;
        public Long consumerId;
        public String ua;

        private Model() {
        }

        public boolean equalsTo(Model obj) {
            return obj.appId.equals(this.appId) && obj.gtype.equals(this.gtype) && obj.gid.equals(this.gid) && obj.credits.equals(this.credits) && obj.ua != null && this.ua != null && obj.ua.equals(this.ua);
        }
    }
}

