/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatStrategyAppConfigEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.CacheExchangeEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import cn.com.duiba.boot.ext.autoconfigure.logger.JsonLoggerFactory;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatSameDeapStrategy
implements AnticheatStrategy {
    private static final Logger LOGGER = JsonLoggerFactory.getLogger(AnticheatSameDeapStrategy.class);
    private final String NAMESPACE = "anticheat";
    public final String ADD = "add";
    public final String UPDATE = "update";
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Autowired
    private MemcachedClient memcachedClient;

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-deap").getEnable();
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-deap").getCheckMode();
    }

    @Override
    public boolean isBlackMode() {
        return true;
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("same-deap").getEffectMode();
    }

    @Override
    public boolean isAppEnable(Long appId) {
        Map<Long, AnticheatStrategyAppConfigEntity> map = this.anticheatStrategyConfigService.getCacheAppConfig("same-deap");
        return map.containsKey(appId);
    }

    private void insertExchange(String cacheKey, boolean status, ConsumerParams consumer, RequestParams request) {
        try {
            ArrayList<CacheExchangeEntity> list = new ArrayList<CacheExchangeEntity>();
            CacheExchangeEntity ce = new CacheExchangeEntity();
            ce.setConsumerId(consumer.getConsumerId());
            ce.setAppId(consumer.getAppId());
            ce.setStatus(status ? 0 : 1);
            ce.setIp(request.getIp());
            ce.setUa(request.getUserAgent());
            ce.setGmtCreate(System.currentTimeMillis());
            ce.setPersistent(false);
            list.add(ce);
            this.casExchange(cacheKey, list, "add");
        }
        catch (Exception e) {
            LOGGER.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdmemcached\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
        }
    }

    private Integer casExchange(String key, List<CacheExchangeEntity> value, String type) {
        Integer result = null;
        boolean loop = true;
        try {
            int loopNum = 0;
            while (loop) {
                if (loopNum >= 10) {
                    loop = false;
                    result = 1;
                    break;
                }
                CASValue last = this.memcachedClient.gets(key);
                if (last == null) {
                    loop = false;
                    result = 2;
                    String json = JSON.toJSONString(value);
                    this.memcachedClient.set(key, DateUtils.getToTomorrowSeconds(), (Object)json);
                    break;
                }
                String nextValue = (String)last.getValue();
                List memCes = JSON.parseArray((String)nextValue, CacheExchangeEntity.class);
                if (type.equals("update")) {
                    for (CacheExchangeEntity ce : value) {
                        for (CacheExchangeEntity mce : memCes) {
                            if (!ce.getConsumerId().equals(mce.getConsumerId())) continue;
                            mce.setPersistent(ce.getPersistent());
                        }
                    }
                } else if (type.equals("add")) {
                    memCes.addAll(value);
                }
                nextValue = JSON.toJSONString((Object)memCes);
                CASResponse caseResponse = this.memcachedClient.cas(key, last.getCas(), DateUtils.getToTomorrowSeconds(), (Object)nextValue, (Transcoder)new SerializingTranscoder());
                switch (caseResponse) {
                    case OK: {
                        loop = false;
                        result = 0;
                        break;
                    }
                    case NOT_FOUND: {
                        loop = false;
                        result = 2;
                        break;
                    }
                    case EXISTS: {
                        loop = true;
                    }
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            result = 5;
        }
        return result;
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        String deviceNumber = request.getDeap();
        Integer limitCount = goods.getLimitCount();
        if (deviceNumber == null) {
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        if (limitCount == null) {
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        Integer gtype = goods.getGtype();
        Long gid = goods.getGid();
        Long appId = consumer.getAppId();
        String cachekey = String.format("%s-%s-appId-%s-gtype-%s-gid-%s", "anticheat", deviceNumber, appId, gtype, gid);
        String exchanges = (String)this.memcachedClient.get(cachekey);
        if (StringUtils.isNotEmpty((CharSequence)exchanges)) {
            List list = JSON.parseArray((String)exchanges, CacheExchangeEntity.class);
            if (list.size() >= limitCount) {
                Long debugId = this.doMatchProcess(consumer, goods, request);
                return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
            }
            this.insertExchange(cachekey, true, consumer, request);
        } else {
            this.insertExchange(cachekey, true, consumer, request);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("same-deap");
        debug.setMessage(String.format("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd: %s, \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdlimitCount: %s \ufffd\ufffd\ufffd", request.getDeap(), goods.getLimitCount()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }
}

