/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.biz.strategy.goods.impl;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatDebugLogDao;
import cn.com.duiba.anticheat.center.biz.dao.goods.AnticheatWhiteItemDao;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatDebugLogEntity;
import cn.com.duiba.anticheat.center.biz.entity.goods.AnticheatWhiteItemEntity;
import cn.com.duiba.anticheat.center.biz.strategy.goods.AnticheatStrategy;
import cn.com.duiba.anticheat.center.biz.strategy.goods.impl.AnticheatStrategyConfigService;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnticheatWhiteItemStrategy
implements AnticheatStrategy {
    @Autowired
    private AnticheatWhiteItemDao anticheatWhiteItemDao;
    @Autowired
    private AnticheatDebugLogDao anticheatDebugLogDao;
    @Autowired
    private AnticheatStrategyConfigService anticheatStrategyConfigService;

    @Override
    public boolean isAppEnable(Long appId) {
        return true;
    }

    @Override
    public int getCheckMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("white-item").getCheckMode();
    }

    @Override
    public int getEffectMode() {
        return this.anticheatStrategyConfigService.getCacheConfig("white-item").getEffectMode();
    }

    @Override
    public boolean isEnable() {
        return this.anticheatStrategyConfigService.getCacheConfig("white-item").getEnable();
    }

    public AnticheatWhiteItemEntity checkInWhiteList(Long itemId) {
        AnticheatWhiteItemEntity record;
        if (itemId != null && (record = this.anticheatWhiteItemDao.findWhiteItemById(itemId)) != null) {
            return record;
        }
        return null;
    }

    @Override
    public AnticheatStrategy.AnticheatStrategyResult checkCouponExchange(ConsumerParams consumer, GoodsParams goods, RequestParams request, BehaviorParams behavior) {
        if (GoodsTypeEnum.DUIBA.getGtype() != goods.getGtype().intValue()) {
            return new AnticheatStrategy.AnticheatStrategyResult(false);
        }
        Long itemId = goods.getGid();
        AnticheatWhiteItemEntity record = this.checkInWhiteList(itemId);
        if (record != null) {
            Long debugId = this.doMatchProcess(consumer, goods, request);
            return new AnticheatStrategy.AnticheatStrategyResult(true, debugId);
        }
        return new AnticheatStrategy.AnticheatStrategyResult(false);
    }

    private Long doMatchProcess(ConsumerParams consumer, GoodsParams goods, RequestParams request) {
        AnticheatDebugLogEntity debug = new AnticheatDebugLogEntity(true);
        debug.setAppId(consumer.getAppId());
        debug.setItemId(null);
        debug.setAppItemId(null);
        debug.setGtype(goods.getGtype());
        debug.setGid(goods.getGid());
        debug.setConsumerId(consumer.getConsumerId());
        debug.setPartnerUserId(consumer.getPartnerUserId());
        debug.setIp(request.getIp());
        debug.setStrategyType("white-item");
        debug.setMessage(String.format("\ufffd\ufffd\ufffditem\ufffd\ufffd\ufffditem\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd%s", goods.getGid()));
        this.anticheatDebugLogDao.insert(debug);
        return debug.getId();
    }

    @Override
    public boolean isBlackMode() {
        return false;
    }
}

