/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.MergeCommandsAware;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.BinaryDecodeStatus;
import net.rubyeye.xmemcached.command.binary.BinaryStoreCommand;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.command.binary.ResponseStatus;
import net.rubyeye.xmemcached.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinarySetMultiCommand
extends BaseBinaryCommand
implements MergeCommandsAware {
    private boolean finished;
    private Integer responseOpaque;
    private Map<Object, Command> mergeCommands;

    public BinarySetMultiCommand(String key, CommandType cmdType, CountDownLatch latch) {
        super(key, null, cmdType, latch, 0, 0L, null, false, null);
        this.result = new HashMap();
    }

    @Override
    protected boolean readOpCode(ByteBuffer buffer) {
        byte opCode = buffer.get();
        if (opCode == OpCode.SET.fieldValue()) {
            this.finished = true;
        }
        return true;
    }

    @Override
    protected void readHeader(ByteBuffer buffer) {
        super.readHeader(buffer);
        if (this.responseStatus != ResponseStatus.NO_ERROR && ByteUtils.stepBuffer(buffer, this.responseTotalBodyLength)) {
            this.decodeStatus = BinaryDecodeStatus.DONE;
        }
    }

    @Override
    public Map<Object, Command> getMergeCommands() {
        return this.mergeCommands;
    }

    @Override
    public void setMergeCommands(Map<Object, Command> mergeCommands) {
        this.mergeCommands = mergeCommands;
    }

    @Override
    public void encode() {
    }

    @Override
    protected boolean finish() {
        BinaryStoreCommand command;
        Boolean rt = (Boolean)((Map)this.result).get(this.responseOpaque);
        Map<Object, Command> mergetCommands = this.getMergeCommands();
        if (mergetCommands != null && (command = (BinaryStoreCommand)mergetCommands.remove(this.responseOpaque)) != null) {
            command.setResult(rt);
            command.countDownLatch();
            --this.mergeCount;
        }
        if (this.finished) {
            if (this.getMergeCommands() != null) {
                Collection<Command> mergeCommands = this.getMergeCommands().values();
                this.getIoBuffer().free();
                for (Command nextCommand : mergeCommands) {
                    BinaryStoreCommand command2 = (BinaryStoreCommand)nextCommand;
                    command2.setResult(Boolean.TRUE);
                    command2.countDownLatch();
                    --this.mergeCount;
                }
            }
            assert (this.mergeCount == 0);
            this.countDownLatch();
        } else {
            this.responseOpaque = null;
        }
        return this.finished;
    }

    @Override
    protected boolean readOpaque(ByteBuffer buffer) {
        this.responseOpaque = buffer.getInt();
        Command cmd = this.getMergeCommands().get(this.responseOpaque);
        if (cmd == null) {
            return false;
        }
        if (this.responseStatus == ResponseStatus.NO_ERROR) {
            ((Map)this.result).put(this.responseOpaque, Boolean.TRUE);
        } else {
            ((Map)this.result).put(this.responseOpaque, Boolean.FALSE);
        }
        return true;
    }
}

