/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextDeleteCommand
extends Command {
    protected int time;

    public TextDeleteCommand(String key, byte[] keyBytes, int time, CountDownLatch latch, boolean noreply) {
        super(key, keyBytes, latch);
        this.commandType = CommandType.DELETE;
        this.time = time;
        this.noreply = noreply;
    }

    public final int getTime() {
        return this.time;
    }

    public final void setTime(int time) {
        this.time = time;
    }

    public boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return false;
        }
        if (this.result == null) {
            byte first = buffer.get(buffer.position());
            if (first == 68) {
                this.setResult(Boolean.TRUE);
                this.countDownLatch();
                return ByteUtils.stepBuffer(buffer, 9);
            }
            if (first == 78) {
                this.setResult(Boolean.FALSE);
                this.countDownLatch();
                return ByteUtils.stepBuffer(buffer, 11);
            }
            return this.decodeError(session, buffer);
        }
        Boolean result = (Boolean)this.result;
        if (result.booleanValue()) {
            return ByteUtils.stepBuffer(buffer, 9);
        }
        return ByteUtils.stepBuffer(buffer, 11);
    }

    public final void encode() {
        int size = Constants.DELETE.length + 1 + this.keyBytes.length + Constants.CRLF.length;
        if (this.isNoreply()) {
            size += 8;
        }
        byte[] buf = new byte[size];
        if (this.isNoreply()) {
            ByteUtils.setArguments(buf, 0, Constants.DELETE, this.keyBytes, Constants.NO_REPLY);
        } else {
            ByteUtils.setArguments(buf, 0, Constants.DELETE, this.keyBytes);
        }
        this.ioBuffer = IoBuffer.wrap(buf);
    }
}

