/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.monitor.Constants;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextTouchCommand
extends Command {
    private static final String NOT_FOUND = "NOT_FOUND\r\n";
    private static final String TOUCHED = "TOUCHED\r\n";
    private int expTime;

    public TextTouchCommand(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch, int expTime, boolean noreply) {
        super(key, keyBytes, cmdType, latch);
        this.expTime = expTime;
        this.noreply = noreply;
    }

    public int getExpTime() {
        return this.expTime;
    }

    public void setExpTime(int expTime) {
        this.expTime = expTime;
    }

    public final boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return false;
        }
        if (this.result == null) {
            if (buffer.remaining() < 1) {
                return false;
            }
            byte first = buffer.get(buffer.position());
            if (first == 84) {
                this.setResult(Boolean.TRUE);
                this.countDownLatch();
                return ByteUtils.stepBuffer(buffer, TOUCHED.length());
            }
            if (first == 78) {
                this.setResult(Boolean.FALSE);
                this.countDownLatch();
                return ByteUtils.stepBuffer(buffer, NOT_FOUND.length());
            }
            return this.decodeError(session, buffer);
        }
        Boolean result = (Boolean)this.result;
        if (result.booleanValue()) {
            return ByteUtils.stepBuffer(buffer, TOUCHED.length());
        }
        return ByteUtils.stepBuffer(buffer, NOT_FOUND.length());
    }

    public final void encode() {
        byte[] cmdBytes = Constants.TOUCH;
        int size = 7 + this.keyBytes.length + ByteUtils.stringSize(this.expTime) + Constants.CRLF.length;
        if (this.isNoreply()) {
            size += 8;
        }
        byte[] buf = new byte[size];
        if (this.isNoreply()) {
            ByteUtils.setArguments(buf, 0, cmdBytes, this.keyBytes, this.expTime, Constants.NO_REPLY);
        } else {
            ByteUtils.setArguments(buf, 0, cmdBytes, this.keyBytes, this.expTime);
        }
        this.ioBuffer = IoBuffer.wrap(buf);
    }
}

