/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.catmonitor;

import cn.com.duiba.catmonitor.CatInstance;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Event;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Activate(group={"provider", "consumer"}, order=-9000)
public class CatTransaction
implements Filter {
    private static final ThreadLocal<Cat.Context> CAT_CONTEXT = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (!CatInstance.isEnable()) {
            Result result = invoker.invoke(invocation);
            return result;
        }
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        String loggerName = invoker.getInterface().getSimpleName() + "." + invocation.getMethodName();
        String type = "PigeonCall";
        if ("provider".equals(sideKey)) {
            type = "PigeonService";
        }
        Transaction transaction = Cat.newTransaction((String)type, (String)loggerName);
        Result result = null;
        try {
            Cat.Context context = this.getContext();
            if ("consumer".equals(sideKey)) {
                this.createConsumerCross(url, transaction);
                Cat.logRemoteCallClient((Cat.Context)context);
            } else {
                this.createProviderCross(url, transaction);
                Cat.logRemoteCallServer((Cat.Context)context);
            }
            this.setAttachment(context);
            result = invoker.invoke(invocation);
            if (result.hasException()) {
                Cat.logError((Throwable)result.getException());
                transaction.setStatus(result.getException().getClass().getSimpleName());
            } else {
                transaction.setStatus("0");
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            transaction.setStatus(e.getClass().getSimpleName());
        }
        finally {
            transaction.complete();
            CAT_CONTEXT.remove();
        }
        return result;
    }

    private String getProviderAppName(URL url) {
        String appName = url.getParameter("serverApplicationName");
        if (StringUtils.isEmpty((String)appName)) {
            String interfaceName = url.getParameter("interface");
            appName = interfaceName.substring(0, interfaceName.lastIndexOf(46));
        }
        return appName;
    }

    private void setAttachment(Cat.Context context) {
        RpcContext.getContext().setAttachment("_catRootMessageId", context.getProperty("_catRootMessageId"));
        RpcContext.getContext().setAttachment("_catChildMessageId", context.getProperty("_catChildMessageId"));
        RpcContext.getContext().setAttachment("_catParentMessageId", context.getProperty("_catParentMessageId"));
    }

    private Cat.Context getContext() {
        Cat.Context context = CAT_CONTEXT.get();
        if (context == null) {
            context = this.initContext();
            CAT_CONTEXT.set(context);
        }
        return context;
    }

    private Cat.Context initContext() {
        DubboCatContext context = new DubboCatContext();
        Map attachments = RpcContext.getContext().getAttachments();
        if (attachments != null && attachments.size() > 0) {
            for (Map.Entry entry : attachments.entrySet()) {
                if (!"_catChildMessageId".equals(entry.getKey()) && !"_catRootMessageId".equals(entry.getKey()) && !"_catParentMessageId".equals(entry.getKey())) continue;
                context.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return context;
    }

    private void createConsumerCross(URL url, Transaction transaction) {
        Event crossAppEvent = Cat.newEvent((String)"PigeonCall.app", (String)this.getProviderAppName(url));
        Event crossServerEvent = Cat.newEvent((String)"PigeonCall.server", (String)url.getHost());
        Event crossPortEvent = Cat.newEvent((String)"PigeonCall.port", (String)(url.getPort() + ""));
        crossAppEvent.setStatus("0");
        crossServerEvent.setStatus("0");
        crossPortEvent.setStatus("0");
        this.completeEvent(crossAppEvent);
        this.completeEvent(crossPortEvent);
        this.completeEvent(crossServerEvent);
        transaction.addChild((Message)crossAppEvent);
        transaction.addChild((Message)crossPortEvent);
        transaction.addChild((Message)crossServerEvent);
    }

    private void completeEvent(Event event) {
        AbstractMessage message = (AbstractMessage)event;
        message.setCompleted(true);
    }

    private void createProviderCross(URL url, Transaction transaction) {
        String consumerAppName = RpcContext.getContext().getAttachment("application");
        if (StringUtils.isEmpty((String)consumerAppName)) {
            consumerAppName = RpcContext.getContext().getRemoteHost() + ":" + RpcContext.getContext().getRemotePort();
        }
        Event crossAppEvent = Cat.newEvent((String)"PigeonService.app", (String)consumerAppName);
        Event crossServerEvent = Cat.newEvent((String)"PigeonService.client", (String)RpcContext.getContext().getRemoteHost());
        crossAppEvent.setStatus("0");
        crossServerEvent.setStatus("0");
        this.completeEvent(crossAppEvent);
        this.completeEvent(crossServerEvent);
        transaction.addChild((Message)crossAppEvent);
        transaction.addChild((Message)crossServerEvent);
    }

    static class DubboCatContext
    implements Cat.Context {
        private Map<String, String> properties = new HashMap<String, String>();

        DubboCatContext() {
        }

        public void addProperty(String key, String value) {
            this.properties.put(key, value);
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }
    }
}

