/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.election;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.internal.election.ElectionNode;
import com.dangdang.ddframe.job.internal.election.LeaderElectionService;
import com.dangdang.ddframe.job.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.internal.sharding.ShardingService;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectionListenerManager
extends AbstractListenerManager {
    private static final Logger log = LoggerFactory.getLogger(ElectionListenerManager.class);
    private final LeaderElectionService leaderElectionService;
    private final ShardingService shardingService;
    private final ElectionNode electionNode;

    public ElectionListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        super(coordinatorRegistryCenter, jobConfiguration);
        this.leaderElectionService = new LeaderElectionService(coordinatorRegistryCenter, jobConfiguration);
        this.shardingService = new ShardingService(coordinatorRegistryCenter, jobConfiguration);
        this.electionNode = new ElectionNode(jobConfiguration.getJobName());
    }

    @Override
    public void start() {
        this.addDataListener(new LeaderElectionJobListener());
    }

    class LeaderElectionJobListener
    extends AbstractJobListener {
        LeaderElectionJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (ElectionListenerManager.this.electionNode.isLeaderHostPath(path) && TreeCacheEvent.Type.NODE_REMOVED == event.getType() && !ElectionListenerManager.this.leaderElectionService.hasLeader()) {
                log.debug("Elastic job: leader crashed, elect a new leader now.");
                ElectionListenerManager.this.leaderElectionService.leaderElection();
                ElectionListenerManager.this.shardingService.setReshardingFlag();
                log.debug("Elastic job: leader election completed.");
            }
        }
    }
}

