/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.job;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.internal.schedule.JobFacade;
import com.dangdang.ddframe.job.internal.schedule.JobRegistry;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElasticJob
implements ElasticJob {
    private static final Logger log = LoggerFactory.getLogger(AbstractElasticJob.class);
    private JobFacade jobFacade;

    public final void execute(JobExecutionContext context) throws JobExecutionException {
        log.trace("Elastic job: job execute begin, job execution context:{}.", (Object)context);
        this.jobFacade.checkMaxTimeDiffSecondsTolerable();
        JobExecutionMultipleShardingContext shardingContext = this.jobFacade.getShardingContext();
        if (this.jobFacade.misfireIfNecessary(shardingContext.getShardingItems())) {
            log.debug("Elastic job: previous job is still running, new job will start after previous job completed. Misfired job had recorded.");
            return;
        }
        try {
            this.jobFacade.beforeJobExecuted(shardingContext);
        }
        catch (Throwable cause) {
            this.handleJobExecutionException(new JobExecutionException(cause));
        }
        this.executeJobInternal(shardingContext);
        log.trace("Elastic job: execute normal completed, sharding context:{}.", (Object)shardingContext);
        while (this.jobFacade.isExecuteMisfired(shardingContext.getShardingItems())) {
            log.trace("Elastic job: execute misfired job, sharding context:{}.", (Object)shardingContext);
            this.jobFacade.clearMisfire(shardingContext.getShardingItems());
            this.executeJobInternal(shardingContext);
            log.trace("Elastic job: misfired job completed, sharding context:{}.", (Object)shardingContext);
        }
        this.jobFacade.failoverIfNecessary();
        try {
            this.jobFacade.afterJobExecuted(shardingContext);
        }
        catch (Throwable cause) {
            this.handleJobExecutionException(new JobExecutionException(cause));
        }
        log.trace("Elastic job: execute all completed, job execution context:{}.", (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJobInternal(JobExecutionMultipleShardingContext shardingContext) throws JobExecutionException {
        if (shardingContext.getShardingItems().isEmpty()) {
            log.trace("Elastic job: sharding item is empty, job execution context:{}.", (Object)shardingContext);
            return;
        }
        this.jobFacade.registerJobBegin(shardingContext);
        try {
            this.executeJob(shardingContext);
        }
        catch (Throwable cause) {
            this.handleJobExecutionException(new JobExecutionException(cause));
        }
        finally {
            this.jobFacade.registerJobCompleted(shardingContext);
        }
    }

    protected abstract void executeJob(JobExecutionMultipleShardingContext var1);

    @Override
    public void handleJobExecutionException(JobExecutionException jobExecutionException) throws JobExecutionException {
        throw jobExecutionException;
    }

    public final void setJobFacade(JobFacade jobFacade) {
        this.jobFacade = jobFacade;
        JobRegistry.getInstance().addJobInstance(jobFacade.getJobName(), this);
    }

    protected JobFacade getJobFacade() {
        return this.jobFacade;
    }
}

