/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.schedule;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.internal.execution.ExecutionContextService;
import com.dangdang.ddframe.job.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.internal.failover.FailoverService;
import com.dangdang.ddframe.job.internal.offset.OffsetService;
import com.dangdang.ddframe.job.internal.server.ServerService;
import com.dangdang.ddframe.job.internal.sharding.ShardingService;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.List;

public class JobFacade {
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final ServerService serverService;
    private final ExecutionContextService executionContextService;
    private final ExecutionService executionService;
    private final FailoverService failoverService;
    private final OffsetService offsetService;
    private final List<ElasticJobListener> elasticJobListeners;

    public JobFacade(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration, List<ElasticJobListener> elasticJobListeners) {
        this.configService = new ConfigurationService(coordinatorRegistryCenter, jobConfiguration);
        this.shardingService = new ShardingService(coordinatorRegistryCenter, jobConfiguration);
        this.serverService = new ServerService(coordinatorRegistryCenter, jobConfiguration);
        this.executionContextService = new ExecutionContextService(coordinatorRegistryCenter, jobConfiguration);
        this.executionService = new ExecutionService(coordinatorRegistryCenter, jobConfiguration);
        this.failoverService = new FailoverService(coordinatorRegistryCenter, jobConfiguration);
        this.offsetService = new OffsetService(coordinatorRegistryCenter, jobConfiguration);
        this.elasticJobListeners = elasticJobListeners;
    }

    public String getJobName() {
        return this.configService.getJobName();
    }

    public int getConcurrentDataProcessThreadCount() {
        return this.configService.getConcurrentDataProcessThreadCount();
    }

    public void checkMaxTimeDiffSecondsTolerable() {
        this.configService.checkMaxTimeDiffSecondsTolerable();
    }

    public void failoverIfNecessary() {
        if (this.configService.isFailover() && !this.serverService.isJobStoppedManually()) {
            this.failoverService.failoverIfNecessary();
        }
    }

    public void registerJobBegin(JobExecutionMultipleShardingContext shardingContext) {
        this.executionService.registerJobBegin(shardingContext);
    }

    public void registerJobCompleted(JobExecutionMultipleShardingContext shardingContext) {
        this.executionService.registerJobCompleted(shardingContext);
        if (this.configService.isFailover()) {
            this.failoverService.updateFailoverComplete(shardingContext.getShardingItems());
        }
    }

    public JobExecutionMultipleShardingContext getShardingContext() {
        List<Integer> failoverItems;
        boolean isFailover = this.configService.isFailover();
        if (isFailover && !(failoverItems = this.failoverService.getLocalHostFailoverItems()).isEmpty()) {
            return this.executionContextService.getJobExecutionShardingContext(failoverItems);
        }
        this.shardingService.shardingIfNecessary();
        List<Integer> shardingItems = this.shardingService.getLocalHostShardingItems();
        if (isFailover) {
            shardingItems.removeAll(this.failoverService.getLocalHostTakeOffItems());
        }
        return this.executionContextService.getJobExecutionShardingContext(shardingItems);
    }

    public boolean misfireIfNecessary(List<Integer> shardingItems) {
        return this.executionService.misfireIfNecessary(shardingItems);
    }

    public void clearMisfire(List<Integer> shardingItems) {
        this.executionService.clearMisfire(shardingItems);
    }

    public boolean isExecuteMisfired(List<Integer> shardingItems) {
        return this.isEligibleForJobRunning() && this.configService.isMisfire() && !this.executionService.getMisfiredJobItems(shardingItems).isEmpty();
    }

    public boolean isEligibleForJobRunning() {
        return !this.serverService.isJobStoppedManually() && !this.shardingService.isNeedSharding();
    }

    public boolean isNeedSharding() {
        return this.shardingService.isNeedSharding();
    }

    public void updateOffset(int item, String offset) {
        this.offsetService.updateOffset(item, offset);
    }

    public void beforeJobExecuted(JobExecutionMultipleShardingContext shardingContext) {
        for (ElasticJobListener each : this.elasticJobListeners) {
            each.beforeJobExecuted(shardingContext);
        }
    }

    public void afterJobExecuted(JobExecutionMultipleShardingContext shardingContext) {
        for (ElasticJobListener each : this.elasticJobListeners) {
            each.afterJobExecuted(shardingContext);
        }
    }
}

