/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.reg.zookeeper;

import com.dangdang.ddframe.reg.exception.RegExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.test.TestingServer;

public final class NestedZookeeperServers {
    private static NestedZookeeperServers instance = new NestedZookeeperServers();
    private static ConcurrentMap<Integer, TestingServer> nestedServers = new ConcurrentHashMap<Integer, TestingServer>();

    public static NestedZookeeperServers getInstance() {
        return instance;
    }

    public synchronized void startServerIfNotStarted(int port, String dataDir) {
        if (!nestedServers.containsKey(port)) {
            TestingServer testingServer = null;
            try {
                testingServer = new TestingServer(port, new File(dataDir));
            }
            catch (Exception ex) {
                RegExceptionHandler.handleException(ex);
            }
            nestedServers.putIfAbsent(port, testingServer);
        }
    }

    public void closeServer(int port) {
        TestingServer nestedServer = (TestingServer)nestedServers.get(port);
        if (null == nestedServer) {
            return;
        }
        try {
            nestedServer.close();
            nestedServers.remove(port);
        }
        catch (IOException ex) {
            RegExceptionHandler.handleException(ex);
        }
    }

    private NestedZookeeperServers() {
    }
}

