/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import java.util.LinkedHashSet;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.rabbitmq")
public class RabbitProperties {
    private String host = "localhost";
    private int port = 5672;
    private String username;
    private String password;
    private String virtualHost;
    private String addresses;

    public String getHost() {
        if (this.addresses == null) {
            return this.host;
        }
        String[] hosts = StringUtils.delimitedListToStringArray((String)this.addresses, (String)":");
        if (hosts.length == 2) {
            return hosts[0];
        }
        return null;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        if (this.addresses == null) {
            return this.port;
        }
        String[] hosts = StringUtils.delimitedListToStringArray((String)this.addresses, (String)":");
        if (hosts.length >= 2) {
            return Integer.valueOf(StringUtils.commaDelimitedListToStringArray((String)hosts[1])[0]);
        }
        return this.port;
    }

    public void setAddresses(String addresses) {
        this.addresses = this.parseAddresses(addresses);
    }

    public String getAddresses() {
        return this.addresses == null ? this.host + ":" + this.port : this.addresses;
    }

    private String parseAddresses(String addresses) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String address : StringUtils.commaDelimitedListToStringArray((String)addresses)) {
            int index;
            if ((address = address.trim()).startsWith("amqp://")) {
                address = address.substring("amqp://".length());
            }
            if (address.contains("@")) {
                String[] split = StringUtils.split((String)address, (String)"@");
                String creds = split[0];
                address = split[1];
                split = StringUtils.split((String)creds, (String)":");
                this.username = split[0];
                if (split.length > 0) {
                    this.password = split[1];
                }
            }
            if ((index = address.indexOf("/")) >= 0 && index < address.length()) {
                this.setVirtualHost(address.substring(index + 1));
                address = address.substring(0, index);
            }
            if (!address.contains(":")) {
                address = address + ":" + this.port;
            }
            result.add(address);
        }
        return result.isEmpty() ? null : StringUtils.collectionToCommaDelimitedString(result);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = "".equals(virtualHost) ? "/" : virtualHost;
    }
}

