/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jackson;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.ser.DateTimeSerializer;
import com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.autoconfigure.web.HttpMapperProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={ObjectMapper.class})
public class JacksonAutoConfiguration {
    @Autowired
    private ListableBeanFactory beanFactory;

    @PostConstruct
    private void registerModulesWithObjectMappers() {
        Collection<Module> modules = JacksonAutoConfiguration.getBeans(this.beanFactory, Module.class);
        for (ObjectMapper objectMapper : JacksonAutoConfiguration.getBeans(this.beanFactory, ObjectMapper.class)) {
            objectMapper.registerModules(modules);
        }
    }

    private static <T> Collection<T> getBeans(ListableBeanFactory beanFactory, Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, type).values();
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
    @EnableConfigurationProperties(value={HttpMapperProperties.class, JacksonProperties.class})
    static class JacksonObjectMapperBuilderConfiguration
    implements ApplicationContextAware {
        private ApplicationContext applicationContext;
        @Autowired
        private JacksonProperties jacksonProperties;
        @Autowired
        private HttpMapperProperties httpMapperProperties;

        JacksonObjectMapperBuilderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={Jackson2ObjectMapperBuilder.class})
        public Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder() {
            Boolean isJsonPrettyPrint;
            Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
            builder.applicationContext(this.applicationContext);
            Boolean isJsonSortKeys = this.httpMapperProperties.isJsonSortKeys();
            if (isJsonSortKeys != null && isJsonSortKeys.booleanValue()) {
                builder.featuresToEnable(new Object[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS});
            }
            if ((isJsonPrettyPrint = this.httpMapperProperties.isJsonPrettyPrint()) != null && isJsonPrettyPrint.booleanValue()) {
                builder.featuresToEnable(new Object[]{SerializationFeature.INDENT_OUTPUT});
            }
            this.configureFeatures(builder, this.jacksonProperties.getDeserialization());
            this.configureFeatures(builder, this.jacksonProperties.getSerialization());
            this.configureFeatures(builder, this.jacksonProperties.getMapper());
            this.configureFeatures(builder, this.jacksonProperties.getParser());
            this.configureFeatures(builder, this.jacksonProperties.getGenerator());
            this.configureDateFormat(builder);
            this.configurePropertyNamingStrategy(builder);
            this.configureModules(builder);
            return builder;
        }

        private void configureFeatures(Jackson2ObjectMapperBuilder builder, Map<?, Boolean> features) {
            for (Map.Entry<?, Boolean> entry : features.entrySet()) {
                if (entry.getValue() != null && entry.getValue().booleanValue()) {
                    builder.featuresToEnable(new Object[]{entry.getKey()});
                    continue;
                }
                builder.featuresToDisable(new Object[]{entry.getKey()});
            }
        }

        private void configureDateFormat(Jackson2ObjectMapperBuilder builder) {
            String dateFormat = this.jacksonProperties.getDateFormat();
            if (dateFormat != null) {
                try {
                    Class dateFormatClass = ClassUtils.forName((String)dateFormat, null);
                    builder.dateFormat((DateFormat)BeanUtils.instantiateClass((Class)dateFormatClass));
                }
                catch (ClassNotFoundException ex) {
                    builder.dateFormat((DateFormat)new SimpleDateFormat(dateFormat));
                }
            }
        }

        private void configurePropertyNamingStrategy(Jackson2ObjectMapperBuilder builder) {
            String strategy = this.jacksonProperties.getPropertyNamingStrategy();
            if (strategy != null) {
                try {
                    this.configurePropertyNamingStrategyClass(builder, ClassUtils.forName((String)strategy, null));
                }
                catch (ClassNotFoundException ex) {
                    this.configurePropertyNamingStrategyField(builder, strategy);
                }
            }
        }

        private void configurePropertyNamingStrategyClass(Jackson2ObjectMapperBuilder builder, Class<?> propertyNamingStrategyClass) {
            builder.propertyNamingStrategy((PropertyNamingStrategy)BeanUtils.instantiateClass(propertyNamingStrategyClass));
        }

        private void configurePropertyNamingStrategyField(Jackson2ObjectMapperBuilder builder, String fieldName) {
            Field field = ReflectionUtils.findField(PropertyNamingStrategy.class, (String)fieldName, PropertyNamingStrategy.class);
            Assert.notNull((Object)field, (String)("Constant named '" + fieldName + "' not found on " + PropertyNamingStrategy.class.getName()));
            try {
                builder.propertyNamingStrategy((PropertyNamingStrategy)field.get(null));
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void configureModules(Jackson2ObjectMapperBuilder builder) {
            Collection moduleBeans = JacksonAutoConfiguration.getBeans((ListableBeanFactory)this.applicationContext, Module.class);
            builder.modulesToInstall(moduleBeans.toArray(new Module[moduleBeans.size()]));
        }

        public void setApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }
    }

    @Configuration
    @ConditionalOnClass(value={Jackson2ObjectMapperBuilder.class, DateTime.class, DateTimeSerializer.class, JacksonJodaFormat.class})
    static class JodaDateTimeJacksonConfiguration {
        private final Log log = LogFactory.getLog(JodaDateTimeJacksonConfiguration.class);
        @Autowired
        private JacksonProperties jacksonProperties;

        JodaDateTimeJacksonConfiguration() {
        }

        @Bean
        public Module jodaDateTimeSerializationModule() {
            SimpleModule module = new SimpleModule();
            JacksonJodaFormat jacksonJodaFormat = this.getJacksonJodaFormat();
            if (jacksonJodaFormat != null) {
                module.addSerializer(DateTime.class, (JsonSerializer)new DateTimeSerializer(jacksonJodaFormat));
            }
            return module;
        }

        private JacksonJodaFormat getJacksonJodaFormat() {
            block4: {
                if (this.jacksonProperties.getJodaDateTimeFormat() != null) {
                    return new JacksonJodaFormat(DateTimeFormat.forPattern((String)this.jacksonProperties.getJodaDateTimeFormat()).withZoneUTC());
                }
                if (this.jacksonProperties.getDateFormat() != null) {
                    try {
                        return new JacksonJodaFormat(DateTimeFormat.forPattern((String)this.jacksonProperties.getDateFormat()).withZoneUTC());
                    }
                    catch (IllegalArgumentException ex) {
                        if (!this.log.isWarnEnabled()) break block4;
                        this.log.warn((Object)"spring.jackson.date-format could not be used to configure formatting of Joda's DateTime. You may want to configure spring.jackson.joda-date-time-format as well.");
                    }
                }
            }
            return null;
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class, Jackson2ObjectMapperBuilder.class})
    static class JacksonObjectMapperConfiguration {
        JacksonObjectMapperConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnMissingBean(value={ObjectMapper.class})
        public ObjectMapper jacksonObjectMapper(Jackson2ObjectMapperBuilder builder) {
            return builder.createXmlMapper(false).build();
        }
    }
}

