/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.core.common.zookeeper.inner;

import com.baidu.disconf.core.common.zookeeper.inner.ResilientActiveKeyValueStore;
import java.io.IOException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ConfigWatcher
implements Watcher {
    private ResilientActiveKeyValueStore store = new ResilientActiveKeyValueStore(true);

    public ConfigWatcher(String hosts) throws IOException, InterruptedException {
        this.store.connect(hosts);
    }

    public void displayConfig() throws InterruptedException, KeeperException {
        String value = this.store.read("/config", this, null);
        System.out.printf("Read %s as %s\n", "/config", value);
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.NodeDataChanged) {
            try {
                this.displayConfig();
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted. Exiting.");
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                System.err.printf("KeeperException: %s. Exiting.\n", new Object[]{e});
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ConfigWatcher configWatcher = new ConfigWatcher(args[0]);
        configWatcher.displayConfig();
        Thread.sleep(Long.MAX_VALUE);
    }
}

