/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import org.hamcrest.Matcher;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.MatcherAssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;

public class FlashAttributeResultMatchers {
    protected FlashAttributeResultMatchers() {
    }

    public <T> ResultMatcher attribute(final String name, final Matcher<T> matcher) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                MatcherAssertionErrors.assertThat("Flash attribute", result.getFlashMap().get((Object)name), matcher);
            }
        };
    }

    public <T> ResultMatcher attribute(final String name, final Object value) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("Flash attribute", value, result.getFlashMap().get((Object)name));
            }
        };
    }

    public <T> ResultMatcher attributeExists(final String ... names) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                for (String name : names) {
                    AssertionErrors.assertTrue("Flash attribute [" + name + "] does not exist", result.getFlashMap().get((Object)name) != null);
                }
            }
        };
    }

    public <T> ResultMatcher attributeCount(final int count) {
        return new ResultMatcher(){

            @Override
            public void match(MvcResult result) throws Exception {
                AssertionErrors.assertEquals("FlashMap size", count, result.getFlashMap().size());
            }
        };
    }
}

