/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.spring.namespace;

import com.dangdang.ddframe.job.api.listener.AbstractDistributeOnceElasticJobListener;
import com.dangdang.ddframe.job.spring.schedule.SpringJobScheduler;
import com.google.common.base.Strings;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JobBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringJobScheduler.class);
        factory.setInitMethodName("init");
        factory.setDestroyMethodName("shutdown");
        factory.addConstructorArgReference(element.getAttribute("regCenter"));
        factory.addConstructorArgReference(this.createJobConfiguration(element, parserContext));
        factory.addConstructorArgValue(this.createJobListeners(element));
        return factory.getBeanDefinition();
    }

    private String createJobConfiguration(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition((String)"com.dangdang.ddframe.job.api.JobConfiguration");
        factory.addConstructorArgValue((Object)element.getAttribute("id"));
        factory.addConstructorArgValue((Object)element.getAttribute("class"));
        factory.addConstructorArgValue((Object)element.getAttribute("shardingTotalCount"));
        factory.addConstructorArgValue((Object)element.getAttribute("cron"));
        this.addPropertyValueIfNotEmpty("shardingItemParameters", element, factory);
        this.addPropertyValueIfNotEmpty("jobParameter", element, factory);
        this.addPropertyValueIfNotEmpty("monitorExecution", element, factory);
        this.addPropertyValueIfNotEmpty("monitorPort", element, factory);
        this.addPropertyValueIfNotEmpty("processCountIntervalSeconds", element, factory);
        this.addPropertyValueIfNotEmpty("concurrentDataProcessThreadCount", element, factory);
        this.addPropertyValueIfNotEmpty("fetchDataCount", element, factory);
        this.addPropertyValueIfNotEmpty("maxTimeDiffSeconds", element, factory);
        this.addPropertyValueIfNotEmpty("failover", element, factory);
        this.addPropertyValueIfNotEmpty("misfire", element, factory);
        this.addPropertyValueIfNotEmpty("jobShardingStrategyClass", element, factory);
        this.addPropertyValueIfNotEmpty("description", element, factory);
        this.addPropertyValueIfNotEmpty("disabled", element, factory);
        this.addPropertyValueIfNotEmpty("overwrite", element, factory);
        String result = element.getAttribute("id") + "Conf";
        parserContext.getRegistry().registerBeanDefinition(result, (BeanDefinition)factory.getBeanDefinition());
        return result;
    }

    private List<BeanDefinition> createJobListeners(Element element) {
        List listenerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"listener");
        ManagedList result = new ManagedList(listenerElements.size());
        for (Element each : listenerElements) {
            String className = each.getAttribute("class");
            BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition((String)className);
            factory.setScope("prototype");
            try {
                Class<?> listenerClass = Class.forName(className);
                if (AbstractDistributeOnceElasticJobListener.class.isAssignableFrom(listenerClass)) {
                    factory.addConstructorArgValue((Object)each.getAttribute("startedTimeoutMilliseconds"));
                    factory.addConstructorArgValue((Object)each.getAttribute("completedTimeoutMilliseconds"));
                }
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            result.add(factory.getBeanDefinition());
        }
        return result;
    }

    private void addPropertyValueIfNotEmpty(String propertyName, Element element, BeanDefinitionBuilder factory) {
        String propertyValue = element.getAttribute(propertyName);
        if (!Strings.isNullOrEmpty((String)propertyValue)) {
            factory.addPropertyValue(propertyName, (Object)propertyValue);
        }
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

