/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.anticheat.center.common.tools;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutCallable<V>
implements Callable<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutCallable.class);
    private final Callable<V> callable;
    private final long timeout;
    private final V timeoutV;

    public TimeoutCallable(Callable<V> callable, long timeout, V timeoutV) {
        this.callable = callable;
        this.timeout = timeout;
        this.timeoutV = timeoutV;
    }

    @Override
    public V call() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<V> future = executor.submit(this.callable);
        V v = null;
        try {
            v = future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            LOGGER.warn("timeoutCallable \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)ex);
        }
        return v != null ? v : (V)this.timeoutV;
    }
}

