/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Ajc2
extends Javac {
    public static final String ADAPTER_CLASS = "org.aspectj.tools.ant.taskdefs.compilers.Ajc";
    private Integer threads;
    private boolean nocomments;
    private boolean nosymbols;
    private boolean preprocess;
    private File workingdir;
    private List argfiles;
    private boolean haveExcludes = false;
    private boolean haveIncludes = false;

    protected boolean hasExcludes() {
        return this.haveExcludes;
    }

    protected boolean hasIncludes() {
        return this.haveIncludes;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public Integer getThreads() {
        return this.threads;
    }

    public void setNocomments(boolean nocomments) {
        this.nocomments = nocomments;
    }

    public boolean getNocomments() {
        return this.nocomments;
    }

    public void setNosymbols(boolean nosymbols) {
        this.nosymbols = nosymbols;
    }

    public boolean getNosymbols() {
        return this.nosymbols;
    }

    public void setPreprocess(boolean preprocess) {
        this.preprocess = preprocess;
    }

    public boolean getPreprocess() {
        return this.preprocess;
    }

    public void setWorkingdir(File workingdir) {
        this.workingdir = workingdir;
    }

    public File getWorkingdir() {
        return this.workingdir;
    }

    public void setArgfiles(String argfiles) {
        StringTokenizer tok = new StringTokenizer(argfiles, ",");
        while (tok.hasMoreTokens()) {
            File argfile = this.project.resolveFile(tok.nextToken());
            if (argfile == null || !argfile.exists() || argfile.isDirectory()) continue;
            this.createArgfile().setFile(argfile);
        }
    }

    public Argfile createArgfile() {
        Argfile argfile = new Argfile();
        if (this.argfiles == null) {
            this.argfiles = new ArrayList();
        }
        this.argfiles.add(argfile);
        return argfile;
    }

    public List getArgfiles() {
        return this.argfiles;
    }

    public PatternSet.NameEntry createInclude() {
        this.haveIncludes = true;
        return super.createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        this.haveExcludes = true;
        return super.createExclude();
    }

    public void setIncludes(String includes) {
        this.haveIncludes = true;
        super.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        this.haveExcludes = true;
        super.setExcludes(excludes);
    }

    public String getAdapterClass() {
        return ADAPTER_CLASS;
    }

    public final void execute() throws BuildException {
        this.prepare();
        this.executeAfterPrepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAfterPrepare() throws BuildException {
        String javaVersion;
        String oldBuildCompiler = this.project.getProperty("build.compiler");
        if (oldBuildCompiler == null && !(javaVersion = JavaEnvUtils.getJavaVersion()).equals("1.0")) {
            if (javaVersion.equals("1.1")) {
                oldBuildCompiler = "classic";
            } else if (javaVersion.equals("1.2")) {
                oldBuildCompiler = "classic";
            } else if (javaVersion.equals("1.3")) {
                oldBuildCompiler = "modern";
            }
        }
        this.project.setProperty("build.compiler", this.getAdapterClass());
        BuildException caught = null;
        try {
            super.execute();
        }
        catch (BuildException be) {
            caught = be;
        }
        finally {
            if (oldBuildCompiler != null) {
                this.project.setProperty("build.compiler", oldBuildCompiler);
            }
        }
        if (caught != null) {
            throw caught;
        }
    }

    public void prepare() {
        if (this.argfiles != null && !this.haveIncludes && !this.haveExcludes && this.getSrcdir() == null) {
            this.useDefaultSrcdir();
        }
    }

    protected final void useDefaultSrcdir() {
        this.setSrcdir(new Path(this.project, "."));
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        Iterator iter;
        ArrayList<File> newFiles = new ArrayList<File>();
        ArrayList newIncludes = new ArrayList();
        ArrayList newArguments = new ArrayList();
        if (this.argfiles != null) {
            iter = this.argfiles.iterator();
            while (iter.hasNext()) {
                File argfile = ((Argfile)iter.next()).getFile();
                this.expandArgfile(argfile, newIncludes, newArguments);
            }
        }
        if (!this.haveIncludes && !this.haveExcludes && this.argfiles != null) {
            this.log("Setting includes to '!**'", 3);
            this.setIncludes("!**");
        } else {
            for (int i = 0; i < files.length; ++i) {
                File newFile = new File(srcDir, files[i]);
                if (newFile == null || !newFile.exists() || !newFile.getName().endsWith(".java")) continue;
                newFiles.add(newFile);
            }
        }
        iter = newIncludes.iterator();
        while (iter.hasNext()) {
            newFiles.add((File)iter.next());
        }
        int newFileSize = newFiles.size();
        if (newFileSize > 0) {
            File[] newCompileList = new File[this.compileList.length + newFileSize];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles.toArray(), 0, newCompileList, this.compileList.length, newFileSize);
            this.compileList = newCompileList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandArgfile(File argfile, List includes, List arguments) {
        this.log("argfile:" + argfile, 3);
        File parent = argfile.getParentFile();
        if (parent == null || !parent.exists() || !parent.isDirectory()) {
            return;
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(argfile));
            while ((line = in.readLine()) != null) {
                if ("".equals(line = line.trim())) continue;
                int isharp = line.indexOf("#");
                if (isharp != -1) {
                    line = line.substring(0, isharp);
                }
                if (line.startsWith("-")) {
                    arguments.add(line);
                    continue;
                }
                if (line.indexOf("*") != -1) {
                    this.log("The argfile line '" + line + "' is invalid", 1);
                    continue;
                }
                if (line.startsWith("@")) {
                    String newArgfileName = line.substring(1);
                    File newArgfile = new File(parent, newArgfileName);
                    this.expandArgfile(newArgfile, includes, arguments);
                    continue;
                }
                File newfile = new File(line);
                if (!newfile.isAbsolute()) {
                    newfile = new File(parent, line);
                }
                if (newfile == null || !newfile.exists() || newfile.isDirectory() || !newfile.getName().endsWith(".java")) continue;
                includes.add(newfile);
            }
        }
        catch (IOException ioe) {
            this.log("trouble with argfile: " + argfile + ":" + ioe, 0);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe2) {}
        }
    }

    public static class Argfile {
        private File file;

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }
    }
}

