/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.accesslog;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;

public class AccessLogFilter
implements Filter {
    public static ThreadLocal<Long> AppId = new ThreadLocal();
    public static ThreadLocal<Long> ConsumerId = new ThreadLocal();
    private static Logger AccessLog = LoggerFactory.getLogger((String)"duiba_access_log");
    private static Logger log = LoggerFactory.getLogger(AccessLogFilter.class);
    private static final String DUIBA_PERF = "_duibaPerf";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            Cookie[] cookies;
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            boolean isPerfUrl = false;
            String _duibaPerf = req.getParameter(DUIBA_PERF);
            if (_duibaPerf != null && "1".equals(_duibaPerf)) {
                isPerfUrl = true;
            }
            if (!isPerfUrl && (cookies = req.getCookies()) != null) {
                for (Cookie c : cookies) {
                    if (!DUIBA_PERF.equals(c.getName()) || !"1".equals(c.getValue())) continue;
                    isPerfUrl = true;
                    break;
                }
            }
            if (!isPerfUrl) {
                this.processAccessLog(req);
            }
        }
        catch (Exception e) {
            log.error("AccessLogFilter process error, message=" + e.getMessage());
        }
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            AppId.remove();
            ConsumerId.remove();
        }
    }

    private void processAccessLog(HttpServletRequest req) throws Exception {
        String ip;
        String ua;
        Cookie _ac;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url_host", req.getHeader("host"));
        map.put("url_path", req.getRequestURI());
        map.put("url_query", req.getQueryString());
        map.put("http_method", req.getMethod());
        String callback = req.getParameter("callback");
        if (callback != null && !"".equals(callback.trim())) {
            map.put("http_method", "POST");
        }
        Cookie[] cookies = req.getCookies();
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        if (cookies != null) {
            for (Cookie c : cookies) {
                cookieMap.put(c.getName(), c);
            }
        }
        if ((_ac = (Cookie)cookieMap.get("_ac")) != null) {
            String json = null;
            try {
                json = new String(new BASE64Decoder().decodeBuffer(_ac.getValue()), "utf-8");
            }
            catch (Exception e) {
                log.warn("_ac decode fail , _ac= " + _ac.getValue());
            }
            if (json != null) {
                JSONObject object = JSONObject.parseObject((String)json);
                map.put("app_id", object.getLong("aid"));
                map.put("consumer_id", object.getLong("cid"));
            }
        }
        if (!map.containsKey("consumer_id")) {
            Long consumerId;
            Long appId = AppId.get();
            if (appId != null) {
                map.put("app_Id", appId);
            }
            if ((consumerId = ConsumerId.get()) != null) {
                map.put("consumer_id", consumerId);
            }
        }
        HashMap<String, String> collCookie = new HashMap<String, String>();
        for (String key : cookieMap.keySet()) {
            if (!key.startsWith("_coll_")) continue;
            collCookie.put(key, ((Cookie)cookieMap.get(key)).getValue());
        }
        if (!collCookie.isEmpty()) {
            map.put("cookie", collCookie);
        }
        if ((ua = req.getHeader("user-agent")) != null && ua.length() > 500) {
            ua = ua.substring(0, 499);
        }
        if (ua != null) {
            map.put("user_agent", ua);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("time", sdf.format(new Date()));
        String referer = req.getHeader("referer");
        if (referer != null) {
            map.put("referer", referer);
        }
        if ((ip = AccessLogFilter.getIpAddr(req)) != null) {
            map.put("ip", ip);
        }
        AccessLog.info(JSON.toJSONString(map));
    }

    public void destroy() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[size - 1].trim();
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Cdn-Src-Ip");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        return ip;
    }
}

