/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.scan.inner.dynamic;

import com.baidu.disconf.client.common.annotations.DisconfFile;
import com.baidu.disconf.client.common.annotations.DisconfUpdateService;
import com.baidu.disconf.client.common.model.DisconfKey;
import com.baidu.disconf.client.common.update.IDisconfUpdate;
import com.baidu.disconf.client.common.update.IDisconfUpdatePipeline;
import com.baidu.disconf.client.scan.inner.common.ScanVerify;
import com.baidu.disconf.client.scan.inner.dynamic.model.ScanDynamicModel;
import com.baidu.disconf.client.scan.inner.statically.model.ScanStaticModel;
import com.baidu.disconf.client.store.DisconfStorePipelineProcessor;
import com.baidu.disconf.client.store.DisconfStoreProcessor;
import com.baidu.disconf.client.store.DisconfStoreProcessorFactory;
import com.baidu.disconf.client.support.registry.Registry;
import com.baidu.disconf.core.common.constants.DisConfigTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanDynamicStoreAdapter {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ScanDynamicStoreAdapter.class);

    public static void scanUpdateCallbacks(ScanStaticModel scanModel, Registry registry) {
        ScanDynamicModel scanDynamicModel = ScanDynamicStoreAdapter.analysis4DisconfUpdate(scanModel, registry);
        ScanDynamicStoreAdapter.transformUpdateService(scanDynamicModel.getDisconfUpdateServiceInverseIndexMap());
        ScanDynamicStoreAdapter.transformPipelineService(scanDynamicModel.getDisconfUpdatePipeline());
    }

    private static ScanDynamicModel analysis4DisconfUpdate(ScanStaticModel scanModel, Registry registry) {
        IDisconfUpdatePipeline iDisconfUpdatePipeline;
        HashMap<DisconfKey, List<IDisconfUpdate>> inverseMap = new HashMap<DisconfKey, List<IDisconfUpdate>>();
        Set<Class<?>> disconfUpdateServiceSet = scanModel.getDisconfUpdateService();
        for (Class<?> disconfUpdateServiceClass : disconfUpdateServiceSet) {
            IDisconfUpdate iDisconfUpdate;
            DisconfUpdateService disconfUpdateService = disconfUpdateServiceClass.getAnnotation(DisconfUpdateService.class);
            if (!ScanVerify.hasIDisconfUpdate(disconfUpdateServiceClass) || (iDisconfUpdate = ScanDynamicStoreAdapter.getIDisconfUpdateInstance(disconfUpdateServiceClass, registry)) == null) continue;
            ScanDynamicStoreAdapter.processItems(inverseMap, disconfUpdateService, iDisconfUpdate);
            ScanDynamicStoreAdapter.processFiles(inverseMap, disconfUpdateService, iDisconfUpdate);
        }
        ScanDynamicModel scanDynamicModel = new ScanDynamicModel();
        scanDynamicModel.setDisconfUpdateServiceInverseIndexMap(inverseMap);
        if (scanModel.getiDisconfUpdatePipeline() != null && (iDisconfUpdatePipeline = ScanDynamicStoreAdapter.getIDisconfUpdatePipelineInstance(scanModel.getiDisconfUpdatePipeline(), registry)) != null) {
            scanDynamicModel.setDisconfUpdatePipeline(iDisconfUpdatePipeline);
        }
        return scanDynamicModel;
    }

    private static void processItems(Map<DisconfKey, List<IDisconfUpdate>> inverseMap, DisconfUpdateService disconfUpdateService, IDisconfUpdate iDisconfUpdate) {
        List<String> itemKeys = Arrays.asList(disconfUpdateService.itemKeys());
        for (String key : itemKeys) {
            DisconfKey disconfKey = new DisconfKey(DisConfigTypeEnum.ITEM, key);
            ScanDynamicStoreAdapter.addOne2InverseMap(disconfKey, inverseMap, iDisconfUpdate);
        }
    }

    private static void processFiles(Map<DisconfKey, List<IDisconfUpdate>> inverseMap, DisconfUpdateService disconfUpdateService, IDisconfUpdate iDisconfUpdate) {
        DisconfKey disconfKey;
        List<Class<?>> classes = Arrays.asList(disconfUpdateService.classes());
        for (Class<?> curClass : classes) {
            DisconfFile disconfFile = curClass.getAnnotation(DisconfFile.class);
            if (disconfFile == null) {
                LOGGER.error("cannot find DisconfFile annotation for class when set callback: {} ", (Object)curClass.toString());
                continue;
            }
            disconfKey = new DisconfKey(DisConfigTypeEnum.FILE, disconfFile.filename());
            ScanDynamicStoreAdapter.addOne2InverseMap(disconfKey, inverseMap, iDisconfUpdate);
        }
        List<String> fileKeyList = Arrays.asList(disconfUpdateService.confFileKeys());
        for (String fileKey : fileKeyList) {
            disconfKey = new DisconfKey(DisConfigTypeEnum.FILE, fileKey);
            ScanDynamicStoreAdapter.addOne2InverseMap(disconfKey, inverseMap, iDisconfUpdate);
        }
    }

    private static IDisconfUpdate getIDisconfUpdateInstance(Class<?> disconfUpdateServiceClass, Registry registry) {
        Object iDisconfUpdate = registry.getFirstByType(disconfUpdateServiceClass, true);
        if (iDisconfUpdate == null) {
            return null;
        }
        return (IDisconfUpdate)iDisconfUpdate;
    }

    private static IDisconfUpdatePipeline getIDisconfUpdatePipelineInstance(Class<IDisconfUpdatePipeline> disconfUpdateServiceClass, Registry registry) {
        IDisconfUpdatePipeline iDisconfUpdate = registry.getFirstByType(disconfUpdateServiceClass, true);
        if (iDisconfUpdate == null) {
            return null;
        }
        return iDisconfUpdate;
    }

    private static void addOne2InverseMap(DisconfKey disconfKey, Map<DisconfKey, List<IDisconfUpdate>> inverseMap, IDisconfUpdate iDisconfUpdate) {
        if (inverseMap.containsKey(disconfKey)) {
            inverseMap.get(disconfKey).add(iDisconfUpdate);
        } else {
            ArrayList<IDisconfUpdate> serviceList = new ArrayList<IDisconfUpdate>();
            serviceList.add(iDisconfUpdate);
            inverseMap.put(disconfKey, serviceList);
        }
    }

    private static void transformPipelineService(IDisconfUpdatePipeline iDisconfUpdatePipeline) {
        DisconfStorePipelineProcessor disconfStorePipelineProcessor = DisconfStoreProcessorFactory.getDisconfStorePipelineProcessor();
        disconfStorePipelineProcessor.setDisconfUpdatePipeline(iDisconfUpdatePipeline);
    }

    private static void transformUpdateService(Map<DisconfKey, List<IDisconfUpdate>> disconfUpdateServiceInverseIndexMap) {
        DisconfStoreProcessor disconfStoreProcessorFile = DisconfStoreProcessorFactory.getDisconfStoreFileProcessor();
        DisconfStoreProcessor disconfStoreProcessorItem = DisconfStoreProcessorFactory.getDisconfStoreItemProcessor();
        for (DisconfKey disconfKey : disconfUpdateServiceInverseIndexMap.keySet()) {
            try {
                if (disconfKey.getDisConfigTypeEnum().equals((Object)DisConfigTypeEnum.FILE)) {
                    if (!disconfStoreProcessorFile.hasThisConf(disconfKey.getKey())) {
                        throw new Exception();
                    }
                    disconfStoreProcessorFile.addUpdateCallbackList(disconfKey.getKey(), disconfUpdateServiceInverseIndexMap.get(disconfKey));
                    continue;
                }
                if (!disconfKey.getDisConfigTypeEnum().equals((Object)DisConfigTypeEnum.ITEM)) continue;
                if (!disconfStoreProcessorItem.hasThisConf(disconfKey.getKey())) {
                    throw new Exception();
                }
                disconfStoreProcessorItem.addUpdateCallbackList(disconfKey.getKey(), disconfUpdateServiceInverseIndexMap.get(disconfKey));
            }
            catch (Exception e) {
                StringBuffer sb = new StringBuffer();
                sb.append("cannot find " + disconfKey + "for: ");
                for (IDisconfUpdate serClass : disconfUpdateServiceInverseIndexMap.get(disconfKey)) {
                    sb.append(serClass.toString() + "\t");
                }
                LOGGER.error(sb.toString());
            }
        }
    }
}

