/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.client.transform;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.IEntity;
import com.dianping.cat.configuration.client.IVisitor;
import com.dianping.cat.configuration.client.entity.Bind;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Property;
import com.dianping.cat.configuration.client.entity.Server;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMerger
implements IVisitor {
    private Stack<Object> m_objs = new Stack();
    private ClientConfig m_config;

    public DefaultMerger() {
    }

    public DefaultMerger(ClientConfig config) {
        this.m_config = config;
        this.m_objs.push(config);
    }

    public ClientConfig getConfig() {
        return this.m_config;
    }

    protected Stack<Object> getObjects() {
        return this.m_objs;
    }

    public <T> void merge(IEntity<T> to, IEntity<T> from) {
        this.m_objs.push(to);
        from.accept(this);
        this.m_objs.pop();
    }

    protected void mergeBind(Bind to, Bind from) {
        to.mergeAttributes(from);
    }

    protected void mergeConfig(ClientConfig to, ClientConfig from) {
        to.mergeAttributes(from);
        to.setBaseLogDir(from.getBaseLogDir());
    }

    protected void mergeDomain(Domain to, Domain from) {
        to.mergeAttributes(from);
    }

    protected void mergeProperty(Property to, Property from) {
        to.mergeAttributes(from);
        to.setText(from.getText());
    }

    protected void mergeServer(Server to, Server from) {
        to.mergeAttributes(from);
    }

    @Override
    public void visitBind(Bind from) {
        Bind to = (Bind)this.m_objs.peek();
        this.mergeBind(to, from);
        this.visitBindChildren(to, from);
    }

    protected void visitBindChildren(Bind to, Bind from) {
    }

    @Override
    public void visitConfig(ClientConfig from) {
        ClientConfig to = (ClientConfig)this.m_objs.peek();
        this.mergeConfig(to, from);
        this.visitConfigChildren(to, from);
    }

    protected void visitConfigChildren(ClientConfig to, ClientConfig from) {
        BaseEntity target;
        for (Server server : from.getServers()) {
            target = to.findServer(server.getIp());
            if (target == null) {
                target = new Server(server.getIp());
                to.addServer((Server)target);
            }
            this.m_objs.push(target);
            server.accept(this);
            this.m_objs.pop();
        }
        for (Domain domain : from.getDomains().values()) {
            target = to.findDomain(domain.getId());
            if (target == null) {
                target = new Domain(domain.getId());
                to.addDomain((Domain)target);
            }
            this.m_objs.push(target);
            domain.accept(this);
            this.m_objs.pop();
        }
        if (from.getBind() != null) {
            Bind target2 = to.getBind();
            if (target2 == null) {
                target2 = new Bind();
                to.setBind(target2);
            }
            this.m_objs.push(target2);
            from.getBind().accept(this);
            this.m_objs.pop();
        }
        for (Property property : from.getProperties().values()) {
            target = to.findProperty(property.getName());
            if (target == null) {
                target = new Property(property.getName());
                to.addProperty((Property)target);
            }
            this.m_objs.push(target);
            property.accept(this);
            this.m_objs.pop();
        }
    }

    @Override
    public void visitDomain(Domain from) {
        Domain to = (Domain)this.m_objs.peek();
        this.mergeDomain(to, from);
        this.visitDomainChildren(to, from);
    }

    protected void visitDomainChildren(Domain to, Domain from) {
    }

    @Override
    public void visitProperty(Property from) {
        Property to = (Property)this.m_objs.peek();
        this.mergeProperty(to, from);
        this.visitPropertyChildren(to, from);
    }

    protected void visitPropertyChildren(Property to, Property from) {
    }

    @Override
    public void visitServer(Server from) {
        Server to = (Server)this.m_objs.peek();
        this.mergeServer(to, from);
        this.visitServerChildren(to, from);
    }

    protected void visitServerChildren(Server to, Server from) {
    }
}

