/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.internal;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.message.ForkedTransaction;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.TaggedTransaction;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.AbstractMessage;
import com.dianping.cat.message.internal.DefaultEvent;
import com.dianping.cat.message.internal.DefaultForkedTransaction;
import com.dianping.cat.message.internal.DefaultTaggedTransaction;
import com.dianping.cat.message.internal.DefaultTransaction;
import com.dianping.cat.message.internal.MessageIdFactory;
import com.dianping.cat.message.io.MessageSender;
import com.dianping.cat.message.io.TransportManager;
import com.dianping.cat.message.spi.MessageManager;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;

public class DefaultMessageManager
extends ContainerHolder
implements MessageManager,
Initializable,
LogEnabled {
    @Inject
    private ClientConfigManager m_configManager;
    @Inject
    private TransportManager m_transportManager;
    @Inject
    private MessageIdFactory m_factory;
    private ThreadLocal<Context> m_context = new ThreadLocal();
    private long m_throttleTimes;
    private Domain m_domain;
    private String m_hostName;
    private boolean m_firstMessage = true;
    private TransactionHelper m_validator = new TransactionHelper();
    private Map<String, TaggedTransaction> m_taggedTransactions;
    private Logger m_logger;

    public void add(Message message) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.add(message);
        }
    }

    public void bind(String tag, String title) {
        TaggedTransaction t = this.m_taggedTransactions.get(tag);
        if (t != null) {
            MessageTree tree = this.getThreadLocalMessageTree();
            String messageId = tree.getMessageId();
            if (messageId == null) {
                messageId = this.nextMessageId();
                tree.setMessageId(messageId);
            }
            if (tree != null) {
                t.start();
                t.bind(tag, messageId, title);
            }
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void end(Transaction transaction) {
        Context ctx = this.getContext();
        if (ctx != null && transaction.isStandalone() && ctx.end(this, transaction)) {
            this.m_context.remove();
        }
    }

    public void flush(MessageTree tree) {
        MessageSender sender;
        if (tree.getMessageId() == null) {
            tree.setMessageId(this.nextMessageId());
        }
        if ((sender = this.m_transportManager.getSender()) != null && this.isMessageEnabled()) {
            sender.send(tree);
            this.reset();
        } else {
            ++this.m_throttleTimes;
            if (this.m_throttleTimes % 10000L == 0L || this.m_throttleTimes == 1L) {
                this.m_logger.info("Cat Message is throttled! Times:" + this.m_throttleTimes);
            }
        }
    }

    public ClientConfigManager getConfigManager() {
        return this.m_configManager;
    }

    private Context getContext() {
        if (Cat.isInitialized()) {
            Context ctx = this.m_context.get();
            if (ctx != null) {
                return ctx;
            }
            ctx = this.m_domain != null ? new Context(this.m_domain.getId(), this.m_hostName, this.m_domain.getIp()) : new Context("Unknown", this.m_hostName, "");
            this.m_context.set(ctx);
            return ctx;
        }
        return null;
    }

    public String getDomain() {
        return this.m_domain.getId();
    }

    public String getMetricType() {
        return "";
    }

    public Transaction getPeekTransaction() {
        Context ctx = this.getContext();
        if (ctx != null) {
            return ctx.peekTransaction(this);
        }
        return null;
    }

    public MessageTree getThreadLocalMessageTree() {
        Context ctx = this.m_context.get();
        if (ctx == null) {
            this.setup();
        }
        ctx = this.m_context.get();
        return ctx.m_tree;
    }

    public boolean hasContext() {
        return this.m_context.get() != null;
    }

    public void initialize() throws InitializationException {
        this.m_domain = this.m_configManager.getDomain();
        this.m_hostName = NetworkInterfaceManager.INSTANCE.getLocalHostName();
        if (this.m_domain.getIp() == null) {
            this.m_domain.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        }
        try {
            this.m_factory.initialize(this.m_domain.getId());
        }
        catch (IOException e) {
            throw new InitializationException("Error while initializing MessageIdFactory!", (Throwable)e);
        }
        final int size = this.m_configManager.getTaggedTransactionCacheSize();
        this.m_taggedTransactions = new LinkedHashMap<String, TaggedTransaction>(size * 4 / 3 + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, TaggedTransaction> eldest) {
                return this.size() >= size;
            }
        };
    }

    public boolean isCatEnabled() {
        return this.m_domain != null && this.m_domain.isEnabled() && this.m_configManager.isCatEnabled();
    }

    public boolean isMessageEnabled() {
        return this.m_domain != null && this.m_domain.isEnabled() && this.m_context.get() != null && this.m_configManager.isCatEnabled();
    }

    public boolean isTraceMode() {
        Context content = this.getContext();
        if (content != null) {
            return content.isTraceMode();
        }
        return false;
    }

    public void linkAsRunAway(DefaultForkedTransaction transaction) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.linkAsRunAway(transaction);
        }
    }

    public String nextMessageId() {
        return this.m_factory.getNextId();
    }

    public void reset() {
        Context ctx = this.m_context.get();
        if (ctx != null) {
            if (ctx.m_totalDurationInMicros == 0L) {
                ctx.m_stack.clear();
                ctx.m_knownExceptions.clear();
                this.m_context.remove();
            } else {
                ctx.m_knownExceptions.clear();
            }
        }
    }

    public void setMetricType(String metricType) {
    }

    public void setTraceMode(boolean traceMode) {
        Context context = this.getContext();
        if (context != null) {
            context.setTraceMode(traceMode);
        }
    }

    public void setup() {
        Context ctx = this.m_domain != null ? new Context(this.m_domain.getId(), this.m_hostName, this.m_domain.getIp()) : new Context("Unknown", this.m_hostName, "");
        this.m_context.set(ctx);
    }

    boolean shouldLog(Throwable e) {
        Context ctx = this.m_context.get();
        if (ctx != null) {
            return ctx.shouldLog(e);
        }
        return true;
    }

    public void start(Transaction transaction, boolean forked) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.start(transaction, forked);
            if (transaction instanceof TaggedTransaction) {
                TaggedTransaction tt = (TaggedTransaction)transaction;
                this.m_taggedTransactions.put(tt.getTag(), tt);
            }
        } else if (this.m_firstMessage) {
            this.m_firstMessage = false;
            this.m_logger.warn("CAT client is not enabled because it's not initialized yet");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TransactionHelper {
        TransactionHelper() {
        }

        private void linkAsRunAway(DefaultForkedTransaction transaction) {
            DefaultEvent event = new DefaultEvent("RemoteCall", "RunAway");
            event.addData(transaction.getForkedMessageId(), transaction.getType() + ":" + transaction.getName());
            event.setTimestamp(transaction.getTimestamp());
            event.setStatus("0");
            event.setCompleted(true);
            transaction.setStandalone(true);
            DefaultMessageManager.this.add(event);
        }

        private void markAsNotCompleted(DefaultTransaction transaction) {
            DefaultEvent event = new DefaultEvent("cat", "BadInstrument");
            event.setStatus("TransactionNotCompleted");
            event.setCompleted(true);
            transaction.addChild(event);
            transaction.setCompleted(true);
        }

        private void markAsRunAway(Transaction parent, DefaultTaggedTransaction transaction) {
            if (!transaction.hasChildren()) {
                transaction.addData("RunAway");
            }
            transaction.setStatus("0");
            transaction.setStandalone(true);
            transaction.complete();
        }

        private void migrateMessage(Stack<Transaction> stack, Transaction source, Transaction target, int level) {
            Transaction current = level < stack.size() ? (Transaction)stack.get(level) : null;
            boolean shouldKeep = false;
            for (Message child : source.getChildren()) {
                if (child != current) {
                    target.addChild(child);
                    continue;
                }
                DefaultTransaction cloned = new DefaultTransaction(current.getType(), current.getName(), DefaultMessageManager.this);
                cloned.setTimestamp(current.getTimestamp());
                cloned.setDurationInMicros(current.getDurationInMicros());
                cloned.addData(current.getData().toString());
                cloned.setStatus("0");
                target.addChild(cloned);
                this.migrateMessage(stack, current, cloned, level + 1);
                shouldKeep = true;
            }
            source.getChildren().clear();
            if (shouldKeep) {
                source.addChild(current);
            }
        }

        public void truncateAndFlush(Context ctx, long timestamp) {
            MessageTree tree = ctx.m_tree;
            Stack stack = ctx.m_stack;
            Message message = tree.getMessage();
            if (message instanceof DefaultTransaction) {
                Object t;
                String id = tree.getMessageId();
                if (id == null) {
                    id = DefaultMessageManager.this.nextMessageId();
                    tree.setMessageId(id);
                }
                String rootId = tree.getRootMessageId();
                String childId = DefaultMessageManager.this.nextMessageId();
                DefaultTransaction source = (DefaultTransaction)message;
                DefaultTransaction target = new DefaultTransaction(source.getType(), source.getName(), DefaultMessageManager.this);
                target.setTimestamp(source.getTimestamp());
                target.setDurationInMicros(source.getDurationInMicros());
                target.addData(source.getData().toString());
                target.setStatus("0");
                this.migrateMessage(stack, source, target, 1);
                for (int i = stack.size() - 1; i >= 0; --i) {
                    t = (DefaultTransaction)stack.get(i);
                    ((AbstractMessage)t).setTimestamp(timestamp);
                    ((DefaultTransaction)t).setDurationStart(System.nanoTime());
                }
                DefaultEvent next = new DefaultEvent("RemoteCall", "Next");
                next.addData(childId);
                next.setStatus("0");
                target.addChild(next);
                t = tree.copy();
                t.setMessage(target);
                ctx.m_tree.setMessageId(childId);
                ctx.m_tree.setParentMessageId(id);
                ctx.m_tree.setRootMessageId(rootId != null ? rootId : id);
                ctx.m_length = stack.size();
                ctx.m_totalDurationInMicros = ctx.m_totalDurationInMicros + target.getDurationInMicros();
                DefaultMessageManager.this.flush((MessageTree)t);
            }
        }

        public void validate(Transaction parent, Transaction transaction) {
            if (transaction.isStandalone()) {
                List<Message> children = transaction.getChildren();
                int len = children.size();
                for (int i = 0; i < len; ++i) {
                    Message message = children.get(i);
                    if (!(message instanceof Transaction)) continue;
                    this.validate(transaction, (Transaction)message);
                }
                if (!transaction.isCompleted() && transaction instanceof DefaultTransaction) {
                    this.markAsNotCompleted((DefaultTransaction)transaction);
                }
            } else if (!transaction.isCompleted()) {
                if (transaction instanceof DefaultForkedTransaction) {
                    this.linkAsRunAway((DefaultForkedTransaction)transaction);
                } else if (transaction instanceof DefaultTaggedTransaction) {
                    this.markAsRunAway(parent, (DefaultTaggedTransaction)transaction);
                }
            }
        }
    }

    class Context {
        private MessageTree m_tree = new DefaultMessageTree();
        private Stack<Transaction> m_stack = new Stack();
        private int m_length;
        private boolean m_traceMode;
        private long m_totalDurationInMicros;
        private Set<Throwable> m_knownExceptions;

        public Context(String domain, String hostName, String ipAddress) {
            Thread thread = Thread.currentThread();
            String groupName = thread.getThreadGroup().getName();
            this.m_tree.setThreadGroupName(groupName);
            this.m_tree.setThreadId(String.valueOf(thread.getId()));
            this.m_tree.setThreadName(thread.getName());
            this.m_tree.setDomain(domain);
            this.m_tree.setHostName(hostName);
            this.m_tree.setIpAddress(ipAddress);
            this.m_length = 1;
            this.m_knownExceptions = new HashSet<Throwable>();
        }

        public void add(Message message) {
            if (this.m_stack.isEmpty()) {
                MessageTree tree = this.m_tree.copy();
                tree.setMessage(message);
                DefaultMessageManager.this.flush(tree);
            } else {
                Transaction parent = this.m_stack.peek();
                this.addTransactionChild(message, parent);
            }
        }

        private void addTransactionChild(Message message, Transaction transaction) {
            long messagePeriod;
            long treePeriod = this.trimToHour(this.m_tree.getMessage().getTimestamp());
            if (treePeriod < (messagePeriod = this.trimToHour(message.getTimestamp() - 10000L)) || this.m_length >= DefaultMessageManager.this.m_configManager.getMaxMessageLength()) {
                DefaultMessageManager.this.m_validator.truncateAndFlush(this, message.getTimestamp());
            }
            transaction.addChild(message);
            ++this.m_length;
        }

        private void adjustForTruncatedTransaction(Transaction root) {
            DefaultEvent next = new DefaultEvent("TruncatedTransaction", "TotalDuration");
            long actualDurationInMicros = this.m_totalDurationInMicros + root.getDurationInMicros();
            next.addData(String.valueOf(actualDurationInMicros));
            next.setStatus("0");
            root.addChild(next);
            this.m_totalDurationInMicros = 0L;
        }

        public boolean end(DefaultMessageManager manager, Transaction transaction) {
            if (!this.m_stack.isEmpty()) {
                Transaction current = this.m_stack.pop();
                if (transaction == current) {
                    DefaultMessageManager.this.m_validator.validate(this.m_stack.isEmpty() ? null : this.m_stack.peek(), current);
                } else {
                    while (transaction != current && !this.m_stack.empty()) {
                        DefaultMessageManager.this.m_validator.validate(this.m_stack.peek(), current);
                        current = this.m_stack.pop();
                    }
                }
                if (this.m_stack.isEmpty()) {
                    MessageTree tree = this.m_tree.copy();
                    this.m_tree.setMessageId(null);
                    this.m_tree.setMessage(null);
                    if (this.m_totalDurationInMicros > 0L) {
                        this.adjustForTruncatedTransaction((Transaction)tree.getMessage());
                    }
                    manager.flush(tree);
                    return true;
                }
            }
            return false;
        }

        public boolean isTraceMode() {
            return this.m_traceMode;
        }

        public void linkAsRunAway(DefaultForkedTransaction transaction) {
            DefaultMessageManager.this.m_validator.linkAsRunAway(transaction);
        }

        public Transaction peekTransaction(DefaultMessageManager defaultMessageManager) {
            if (this.m_stack.isEmpty()) {
                return null;
            }
            return this.m_stack.peek();
        }

        public void setTraceMode(boolean traceMode) {
            this.m_traceMode = traceMode;
        }

        public boolean shouldLog(Throwable e) {
            if (this.m_knownExceptions == null) {
                this.m_knownExceptions = new HashSet<Throwable>();
            }
            if (this.m_knownExceptions.contains(e)) {
                return false;
            }
            this.m_knownExceptions.add(e);
            return true;
        }

        public void start(Transaction transaction, boolean forked) {
            if (!this.m_stack.isEmpty()) {
                if (!(transaction instanceof ForkedTransaction)) {
                    Transaction parent = this.m_stack.peek();
                    this.addTransactionChild(transaction, parent);
                }
            } else {
                this.m_tree.setMessage(transaction);
            }
            if (!forked) {
                this.m_stack.push(transaction);
            }
        }

        private long trimToHour(long timestamp) {
            return timestamp - timestamp % 3600000L;
        }
    }
}

