package cn.com.duiba.anticheat.center.api.remoteservice.goods;

import cn.com.duiba.anticheat.center.api.domain.goods.*;
import cn.com.duiba.anticheat.center.api.result.goods.ACResultDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 反作弊检查Service
 *
 * @author xuhengfei
 */
public interface RemoteAnticheatCheckService {
    /**
     * 检查是否作弊行为
     *
     * @param consumerId
     * @param itemId
     * @return
     */
    DubboResult<ACResultDto> checkCouponExchange(ConsumerParams consumer, ItemParams item, RequestParams request, BehaviorParams behavior);

    /**
     * 回填调试记录里面的订单号
     *
     * @param debugId
     * @param orderId
     */
    DubboResult<Void> fillbackDebugIds(List<Long> debugIds, Long orderId);

    /**
     * 订单创建
     */
    DubboResult<Void> onOrderCreate(OrderParams order);

    /**
     * 订单失败
     */
    DubboResult<Void> onOrderFail(OrderParams order);
}
