package cn.com.duiba.anticheat.center.api.enums;

/**
 * @author JunAngLiu
 * @Title: RiskRoutBizEnum
 * @Description: 风控路由 活动来源枚举
 * @date 2019/9/714:36
 */
public enum RiskRoutBizEnum {

    ELSE(0,"其它通用"),
    PROJECTX_ACTIVITY(1,"星速台活动"),
    COMMON_ACTIVITY(2,"非星速台活动"),
    APP(3, "应用"),
    ;

    private Integer type;

    private String bizResource;

    public Integer getType() {
        return type;
    }

    public String getBizResource() {
        return bizResource;
    }

    RiskRoutBizEnum(Integer type, String bizResource) {
        this.type = type;
        this.bizResource = bizResource;
    }


    public static RiskRoutBizEnum getByType(Integer type){

        if(type == null){
            return null;
        }
        for(RiskRoutBizEnum item:RiskRoutBizEnum.values()){
            if(item.getType().equals(type)){
                return item;
            }
        }
        return null;
    }
}
