package cn.com.duiba.anticheat.center.api.param;

import cn.com.duiba.anticheat.center.api.enums.ActRiskSenceEnum;
import cn.com.duiba.anticheat.center.api.enums.ProjectXLabelEnum;
import cn.com.duiba.anticheat.center.api.enums.RiskRoutBizEnum;

import java.io.Serializable;

/**
 * @author JunAngLiu
 * @Title: RouteMatchingParam
 * @Description: 风控路由匹配参数
 * @date 2019/9/1016:11
 */
public class RouteMatchingParam implements Serializable {

    private static final long serialVersionUID = -5831785596247791123L;
    /**
     * 活动来源 标明是 星速台活动还是非星速台活动  notnull
     */
    private RiskRoutBizEnum bizEnum;
    /**
     * 活动风控场景 notnull
     */
    private ActRiskSenceEnum senceEnum;
    /**
     * 非星速台活动类型
     */
    private Integer activityType;

    /**
     * 星速台项目 标签
     */
    private ProjectXLabelEnum label;

    /**
     * 项目id
     */
    private String projectId;


    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public RiskRoutBizEnum getBizEnum() {
        return bizEnum;
    }

    public void setBizEnum(RiskRoutBizEnum bizEnum) {
        this.bizEnum = bizEnum;
    }

    public ActRiskSenceEnum getSenceEnum() {
        return senceEnum;
    }

    public void setSenceEnum(ActRiskSenceEnum senceEnum) {
        this.senceEnum = senceEnum;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public ProjectXLabelEnum getLabel() {
        return label;
    }

    public void setLabel(ProjectXLabelEnum label) {
        this.label = label;
    }
}
