package cn.com.duiba.anticheat.center.api.remoteservice.goods;

import cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams;
import cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams;
import cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams;
import cn.com.duiba.anticheat.center.api.domain.goods.OrderParams;
import cn.com.duiba.anticheat.center.api.domain.goods.RequestParams;
import cn.com.duiba.anticheat.center.api.result.goods.ACResultDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 反作弊检查Service
 *
 * @author xuhengfei
 */
@AdvancedFeignClient
public interface RemoteAnticheatCheckService {
    /**
     * 检查是否作弊行为
     *
     * @param consumerId
     * @param itemId
     * @return
     */
    DubboResult<ACResultDto> checkCouponExchange(ConsumerParams consumer, GoodsParams item, RequestParams request, BehaviorParams behavior);

    /**
     * 回填调试记录里面的订单号
     *
     * @param debugId
     * @param orderId
     */
    DubboResult<Void> fillbackDebugIds(List<Long> debugIds, Long orderId);

    /**
     * 订单创建
     */
    DubboResult<Void> onOrderCreate(OrderParams order);

    /**
     * 订单失败
     */
    DubboResult<Void> onOrderFail(OrderParams order);
    
    /**
     * 商品web系统专用，检查是否作弊行为
     *
     * @param consumerId
     * @param itemId
     * @return
     */
    DubboResult<ACResultDto> checkGoodsWebExchange(ConsumerParams consumer, GoodsParams item, RequestParams request, BehaviorParams behavior);
}
