package cn.com.duiba.anticheat.center.api.remoteservice.risk;

import cn.com.duiba.anticheat.center.api.dto.RiskWhiteListDto;
import cn.com.duiba.anticheat.center.api.param.RiksWhitelistMatchingParam;
import cn.com.duiba.anticheat.center.api.param.RiskWhiteListParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RemoteRiskWhiteListService
 * @Description: 风控白名单
 * @date 2019/6/1821:25
 */
@AdvancedFeignClient
public interface RemoteRiskWhiteListService {


    //新增
    int insert(RiskWhiteListDto dto) throws BizException;


    //根据主键修改
    int updateById(RiskWhiteListDto dto);

    /**
     * 条件查询list
     *
     * @param param
     * @return
     */
    Page<RiskWhiteListDto> listByAppConsumerTypeSences(RiskWhiteListParam param);


    /**
     * 新白名单匹配接口
     *
     * @param riksWhitelistMatchingParam 请求参数类
     * @return 是否匹配到白名单 True/False
     */
    Boolean riskWhitelistMatching(RiksWhitelistMatchingParam riksWhitelistMatchingParam) throws BizException;

    /**
     * 根据主键删除操作
     *
     * @return
     */
    void batchDeleteByPrimaryKey(List<Long> ids);

    /**
     * 批量查询
     *
     * @param appId     appId
     * @param riskType  riskType
     * @param riskScene riskScene
     * @param cid       cid
     * @return
     */
    List<RiskWhiteListDto> selectByMultValues(Long appId, Integer riskType, Integer riskScene, List<String> cid);

    /**
     * 查询该ip白名单记录是否已经存在
     *
     * @param riskScene riskScene
     * @param ip        ip
     * @return
     */
    Boolean checkIpExist(Integer riskScene, String ip);

    /**
     * 批量ip白名单插入
     *
     * @param list
     * @return
     */
    int batchIpInsert(List<RiskWhiteListDto> list);

    /**
     * 删除ip白名单
     *
     * @param riskScene riskScene
     * @param ip        ip
     * @return
     */
    int deleteIpWhiteList(Integer riskScene, String ip);
}
