package cn.com.duiba.anticheat.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 禁止增加场景
 * Created by sty on 2018/7/25.
 */
public enum RuleSceneEnum {

  ACTIVITY(0,"活动风险检测","cn.com.duiba.activity"),
  TRADE(1,"交易风险检测","cn.com.duiba.trade"),
  ;

  RuleSceneEnum(Integer type,String desc, String pkg){
    this.type = type;
    this.desc = desc;
    this.pkg = pkg;
  }

  /**
   * 场景编号
   */
  private Integer type;
  /**
   * 场景描述
   */
  private String desc;

  /**
   * 规则所在包
   */
  private String pkg;

  private static Map<Integer, RuleSceneEnum> typeMap = Maps
      .newHashMap();

  public Integer getType() {
    return type;
  }

  public String getDesc() {
    return desc;
  }

  public String getPkg() {
    return pkg;
  }

  static{
    for(RuleSceneEnum typeClass :RuleSceneEnum.values()){
      typeMap.put(typeClass.getType(),typeClass);
    }
  }

  /**
   * 根据type获取具体枚举类型
   * @param key
   * @return
   */
  public static RuleSceneEnum getByType(Integer key){
    return typeMap.get(key);
  }

}
