package cn.com.duiba.anticheat.center.api.enums;

import java.util.Objects;

/**
 * @author JunAngLiu
 * @Title: ActRiskSenceEnum
 * @Description: 活动风控场景
 * @date 2019/6/1820:59
 */
public enum ActRiskSenceEnum {

    WITH_DRAW(1,"提现"),
    PARTICIPATION(2,"参与"),
    PRIZE(3,"发奖");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    ActRiskSenceEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static ActRiskSenceEnum getEnumByValue(Integer value){
        if(Objects.isNull(value)){
            return null;
        }
        for (ActRiskSenceEnum rse: ActRiskSenceEnum.values()) {
            if(Objects.equals(rse.getValue(),value)){
                return rse;
            }
        }
        return null;
    }
}
