package cn.com.duiba.anticheat.center.api.enums;

import java.util.Objects;

/**
 * @author JunAngLiu
 * @Title: RiskSceneMappingEnum
 * @Description: 风控引擎 场景和 兑吧风控场景映射
 * @date 2019/9/1015:00
 */
public enum RiskSceneMappingEnum {

    PARTICIPATION(2,ActRiskSenceEnum.PARTICIPATION,"活动参与"),
    EXCHANGE(4,ActRiskSenceEnum.EXCHANGE,"兑换"),
    ALIPAY_TAKE_PRIZE(5,ActRiskSenceEnum.WITH_DRAW, "支付宝直充领奖"),
    OPETIONS_AWARD(6,ActRiskSenceEnum.PRIZE,"奖品发放"),
    ASSIST(7,ActRiskSenceEnum.ASSIST,"助力"),
    ;

    RiskSceneMappingEnum(Integer type, ActRiskSenceEnum actSence, String desc) {
        this.type = type;
        this.actSence = actSence;
        this.desc = desc;
    }

    /**
     * 场景类型
     */
    private Integer type;

    /**
     * 场景编号
     */
    private ActRiskSenceEnum actSence;

    /**
     * 场景描述
     */
    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public ActRiskSenceEnum getActSence() {
        return actSence;
    }



    public static RiskSceneMappingEnum getEnumByActSence(ActRiskSenceEnum actSence){
        if(Objects.isNull(actSence)){
            return null;
        }
        for (RiskSceneMappingEnum rse:RiskSceneMappingEnum.values()) {
            if(Objects.equals(rse.getActSence(),actSence)){
                return rse;
            }
        }
        return null;
    }
}
