package cn.com.duiba.anticheat.center.api.remoteservice.goods;

import cn.com.duiba.anticheat.center.api.constant.StaticListConstant;
import cn.com.duiba.anticheat.center.api.domain.goods.*;
import cn.com.duiba.anticheat.center.api.result.goods.ACResultDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by gyf .
 * 2017/1/10 .
 */
public class RemoteAnticheatCheckServiceMock implements RemoteAnticheatCheckService {

    @Override
    public DubboResult<ACResultDto> checkCouponExchange(ConsumerParams consumer, GoodsParams item, RequestParams request, BehaviorParams behavior) {
        return DubboResult.successResult(new ACResultDto(true, "mock result", null, ACResultDto.SUB_RESULT_DEFAULT));
    }

    @Override
    public DubboResult<Void> fillbackDebugIds(List<Long> debugIds, Long orderId) {
        return DubboResult.successResult(null);
    }

    @Override
    public DubboResult<Void> onOrderCreate(OrderParams order) {
        return DubboResult.successResult(null);
    }

    @Override
    public DubboResult<Void> onOrderFail(OrderParams order) {
        return DubboResult.successResult(null);
    }

    /**
     * @see cn.com.duiba.anticheat.center.api.remoteservice.goods.RemoteAnticheatCheckService#checkGoodsWebExchange(cn.com.duiba.anticheat.center.api.domain.goods.ConsumerParams, cn.com.duiba.anticheat.center.api.domain.goods.GoodsParams, cn.com.duiba.anticheat.center.api.domain.goods.RequestParams, cn.com.duiba.anticheat.center.api.domain.goods.BehaviorParams)
     */
    @Override
    public DubboResult<ACResultDto> checkGoodsWebExchange(ConsumerParams consumer, GoodsParams item,
                                                          RequestParams request, BehaviorParams behavior) {
        //命中APP白名单直接通过
        if(StaticListConstant.matchWhiteApp(consumer.getAppId())){
            return DubboResult.successResult(new ACResultDto(true, "mock result", null, ACResultDto.SUB_RESULT_DEFAULT));
        }
        return DubboResult.successResult(new ACResultDto(false, "mock result", null, ACResultDto.SUB_RESULT_NEED_IDENTIFYING_CODE));
    }
}
